/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.unboundid.scim2.common.annotations.Nullable;

public class JsonReference<T> {
    private boolean set;
    @Nullable
    private T obj;

    public JsonReference() {
        this.set = false;
        this.obj = null;
    }

    public JsonReference(@Nullable T obj) {
        this.set = true;
        this.obj = obj;
    }

    public boolean isSet() {
        return this.set;
    }

    @Nullable
    public T getObjIfSet() {
        if (this.set) {
            return this.obj;
        }
        throw new RuntimeException("Invalid reference");
    }

    @Nullable
    public T getObj() {
        return this.set ? (T)this.obj : null;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonReference that = (JsonReference)o;
        if (this.set != that.set) {
            return false;
        }
        return !(this.obj == null ? that.obj != null : !this.obj.equals(that.obj));
    }

    public int hashCode() {
        int result = this.set ? 1 : 0;
        result = 31 * result + (this.obj != null ? this.obj.hashCode() : 0);
        return result;
    }
}

