/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.types.AttributeDefinition;

public class Address {
    @Nullable
    @Attribute(description="The full mailing address, formatted for display or use with a mailing label. This attribute MAY contain newlines.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String formatted;
    @Nullable
    @Attribute(description="The full street address component, which may include house number, street name, PO BOX, and multi-line extended street address information. This attribute MAY contain newlines.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String streetAddress;
    @Nullable
    @Attribute(description="The city or locality component.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String locality;
    @Nullable
    @Attribute(description="The state or region component.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String region;
    @Nullable
    @Attribute(description="The zipcode or postal code component.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String postalCode;
    @Nullable
    @Attribute(description="The country name component.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String country;
    @Nullable
    @Attribute(description="A label indicating the attribute's function; e.g., 'work' or 'home'.", isRequired=false, isCaseExact=false, canonicalValues={"work", "home", "other"}, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String type;
    @Nullable
    @Attribute(description="A Boolean value indicating the 'primary' or preferred attribute value for this attribute, e.g., the preferred address. The primary attribute value 'true' MUST appear no more than once.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT)
    private Boolean primary;

    @Nullable
    public String getFormatted() {
        return this.formatted;
    }

    @NotNull
    public Address setFormatted(@Nullable String formatted) {
        this.formatted = formatted;
        return this;
    }

    @Nullable
    public String getStreetAddress() {
        return this.streetAddress;
    }

    @NotNull
    public Address setStreetAddress(@Nullable String streetAddress) {
        this.streetAddress = streetAddress;
        return this;
    }

    @Nullable
    public String getLocality() {
        return this.locality;
    }

    @NotNull
    public Address setLocality(@Nullable String locality) {
        this.locality = locality;
        return this;
    }

    @Nullable
    public String getRegion() {
        return this.region;
    }

    @NotNull
    public Address setRegion(@Nullable String region) {
        this.region = region;
        return this;
    }

    @Nullable
    public String getPostalCode() {
        return this.postalCode;
    }

    @NotNull
    public Address setPostalCode(@Nullable String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    public String getCountry() {
        return this.country;
    }

    @NotNull
    public Address setCountry(@Nullable String country) {
        this.country = country;
        return this;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @NotNull
    public Address setType(@Nullable String type) {
        this.type = type;
        return this;
    }

    @Nullable
    public Boolean getPrimary() {
        return this.primary;
    }

    @NotNull
    public Address setPrimary(@Nullable Boolean primary) {
        this.primary = primary;
        return this;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        if (this.formatted != null ? !this.formatted.equals(address.formatted) : address.formatted != null) {
            return false;
        }
        if (this.streetAddress != null ? !this.streetAddress.equals(address.streetAddress) : address.streetAddress != null) {
            return false;
        }
        if (this.locality != null ? !this.locality.equals(address.locality) : address.locality != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(address.region) : address.region != null) {
            return false;
        }
        if (this.postalCode != null ? !this.postalCode.equals(address.postalCode) : address.postalCode != null) {
            return false;
        }
        if (this.country != null ? !this.country.equals(address.country) : address.country != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(address.type) : address.type != null) {
            return false;
        }
        return !(this.primary == null ? address.primary != null : !this.primary.equals(address.primary));
    }

    public int hashCode() {
        int result = this.formatted != null ? this.formatted.hashCode() : 0;
        result = 31 * result + (this.streetAddress != null ? this.streetAddress.hashCode() : 0);
        result = 31 * result + (this.locality != null ? this.locality.hashCode() : 0);
        result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
        result = 31 * result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
        result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.primary != null ? this.primary.hashCode() : 0);
        return result;
    }
}

