/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.exceptions.BadRequestException;

public enum SortOrder {
    ASCENDING("ascending"),
    DESCENDING("descending");

    @NotNull
    private String name;

    private SortOrder(String name) {
        this.name = name;
    }

    @NotNull
    @JsonValue
    public String getName() {
        return this.name;
    }

    @NotNull
    @JsonCreator
    public static SortOrder fromName(@NotNull String name) throws BadRequestException {
        for (SortOrder sortOrder : SortOrder.values()) {
            if (!sortOrder.getName().equals(name)) continue;
            return sortOrder;
        }
        throw BadRequestException.invalidSyntax("Unknown sort order value " + name);
    }
}

