/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.exceptions;

import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ForbiddenException;
import com.unboundid.scim2.common.exceptions.MethodNotAllowedException;
import com.unboundid.scim2.common.exceptions.NotImplementedException;
import com.unboundid.scim2.common.exceptions.NotModifiedException;
import com.unboundid.scim2.common.exceptions.PreconditionFailedException;
import com.unboundid.scim2.common.exceptions.ResourceConflictException;
import com.unboundid.scim2.common.exceptions.ResourceNotFoundException;
import com.unboundid.scim2.common.exceptions.ServerErrorException;
import com.unboundid.scim2.common.exceptions.UnauthorizedException;
import com.unboundid.scim2.common.messages.ErrorResponse;

public class ScimException
extends Exception {
    @NotNull
    private final ErrorResponse scimError;

    public ScimException(int statusCode, @Nullable String errorMessage) {
        this(statusCode, null, errorMessage);
    }

    public ScimException(int statusCode, @Nullable String scimType, @Nullable String errorMessage) {
        this.scimError = new ErrorResponse(statusCode);
        this.scimError.setScimType(scimType);
        this.scimError.setDetail(errorMessage);
    }

    public ScimException(int statusCode, @Nullable String scimType, @Nullable String errorMessage, @Nullable Throwable cause) {
        super(cause);
        this.scimError = new ErrorResponse(statusCode);
        this.scimError.setScimType(scimType);
        this.scimError.setDetail(errorMessage);
    }

    public ScimException(@NotNull ErrorResponse scimError, @Nullable Throwable cause) {
        super(cause);
        this.scimError = scimError;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.scimError.getDetail();
    }

    @NotNull
    public ErrorResponse getScimError() {
        return this.scimError;
    }

    @NotNull
    public static ScimException createException(int statusCode, @Nullable String errorMessage) {
        return ScimException.createException(statusCode, errorMessage, null);
    }

    @NotNull
    public static ScimException createException(int statusCode, @Nullable String errorMessage, @Nullable Exception cause) {
        ErrorResponse scimError = new ErrorResponse(statusCode);
        scimError.setDetail(errorMessage);
        return ScimException.createException(scimError, cause);
    }

    @NotNull
    public static ScimException createException(@NotNull ErrorResponse scimError, @Nullable Exception cause) {
        switch (scimError.getStatus()) {
            case 304: {
                return new NotModifiedException(scimError, null, cause);
            }
            case 400: {
                return new BadRequestException(scimError, (Throwable)cause);
            }
            case 401: {
                return new UnauthorizedException(scimError, (Throwable)cause);
            }
            case 403: {
                return new ForbiddenException(scimError, (Throwable)cause);
            }
            case 404: {
                return new ResourceNotFoundException(scimError, (Throwable)cause);
            }
            case 405: {
                return new MethodNotAllowedException(scimError, (Throwable)cause);
            }
            case 409: {
                return new ResourceConflictException(scimError, (Throwable)cause);
            }
            case 412: {
                return new PreconditionFailedException(scimError, null, cause);
            }
            case 500: {
                return new ServerErrorException(scimError, (Throwable)cause);
            }
            case 501: {
                return new NotImplementedException(scimError, (Throwable)cause);
            }
        }
        return new ScimException(scimError, (Throwable)cause);
    }
}

