/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.annotations.Schema;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.types.Meta;
import com.unboundid.scim2.common.utils.JsonUtils;
import com.unboundid.scim2.common.utils.SchemaUtils;
import com.unboundid.scim2.common.utils.StaticUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonPropertyOrder(value={"schemas", "id", "externalId"})
public abstract class BaseScimResource
implements ScimResource {
    @Nullable
    private String id;
    @Nullable
    private String externalId;
    @Nullable
    private Meta meta;
    @NotNull
    @JsonProperty(value="schemas")
    private Set<String> schemaUrns = new LinkedHashSet<String>();
    @NotNull
    private final ObjectNode extensionObjectNode = JsonUtils.getJsonNodeFactory().objectNode();

    public BaseScimResource() {
        this(null);
    }

    public BaseScimResource(@Nullable String id) {
        this.id = id;
        this.addMyUrn();
    }

    @NotNull
    @JsonIgnore
    public ObjectNode getExtensionObjectNode() {
        return this.extensionObjectNode;
    }

    @Override
    @Nullable
    public Meta getMeta() {
        return this.meta;
    }

    @Override
    public void setMeta(@Nullable Meta meta) {
        this.meta = meta;
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @Override
    @Nullable
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(@Nullable String externalId) {
        this.externalId = externalId;
    }

    @NotNull
    public Set<String> getSchemaUrns() {
        return this.schemaUrns;
    }

    @Override
    public void setSchemaUrns(@NotNull Collection<String> schemaUrns) {
        Objects.requireNonNull(schemaUrns);
        this.schemaUrns = new LinkedHashSet<String>(schemaUrns);
    }

    @Override
    public void setSchemaUrns(@NotNull String schemaUrn, String ... schemaUrns) {
        this.setSchemaUrns(StaticUtils.toList(schemaUrn, schemaUrns));
    }

    @JsonAnySetter
    protected void setAny(@NotNull String key, @NotNull JsonNode value) throws ScimException {
        if (!SchemaUtils.isUrn(key) || !value.isObject()) {
            String message = "Core attribute " + key + " is undefined";
            Schema schemaAnnotation = this.getClass().getAnnotation(Schema.class);
            if (schemaAnnotation != null) {
                message = message + " for schema " + schemaAnnotation.id();
            }
            throw BadRequestException.invalidSyntax(message);
        }
        this.extensionObjectNode.set(key, value);
    }

    @JsonAnyGetter
    @NotNull
    protected Map<String, Object> getAny() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.extensionObjectNode.size());
        Iterator i = this.extensionObjectNode.fields();
        while (i.hasNext()) {
            Map.Entry field = (Map.Entry)i.next();
            map.put((String)field.getKey(), field.getValue());
        }
        return map;
    }

    private void addMyUrn() {
        String mySchema = SchemaUtils.getSchemaUrn(this.getClass());
        if (mySchema != null && !mySchema.isEmpty()) {
            this.getSchemaUrns().add(mySchema);
        }
    }

    @NotNull
    public List<JsonNode> getExtensionValues(@Nullable String path) throws ScimException {
        return this.getExtensionValues(Path.fromString(path));
    }

    @NotNull
    public List<JsonNode> getExtensionValues(@NotNull Path path) throws ScimException {
        return JsonUtils.findMatchingPaths(path, this.extensionObjectNode);
    }

    public void replaceExtensionValue(@Nullable String path, @NotNull JsonNode value) throws ScimException {
        this.replaceExtensionValue(Path.fromString(path), value);
    }

    public void replaceExtensionValue(@NotNull Path path, @NotNull JsonNode value) throws ScimException {
        JsonUtils.replaceValue(path, this.extensionObjectNode, value);
    }

    @Nullable
    @JsonIgnore
    public <T> T getExtension(@NotNull Class<T> clazz) {
        try {
            JsonNode extensionNode = this.extensionObjectNode.path(this.getSchemaUrnOrThrowException(clazz));
            if (extensionNode.isMissingNode()) {
                return null;
            }
            return JsonUtils.nodeToValue(extensionNode, clazz);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @JsonIgnore
    public <T> void setExtension(@NotNull T extension) {
        String schemaUrn = this.getSchemaUrnOrThrowException(extension.getClass());
        this.extensionObjectNode.set(schemaUrn, JsonUtils.valueToNode(extension));
        this.schemaUrns.add(schemaUrn);
    }

    public <T> boolean removeExtension(@NotNull Class<T> clazz) {
        String schemaUrn = this.getSchemaUrnOrThrowException(clazz);
        if (this.extensionObjectNode.remove(schemaUrn) == null) {
            return false;
        }
        this.schemaUrns.remove(schemaUrn);
        return true;
    }

    @NotNull
    private <T> String getSchemaUrnOrThrowException(@NotNull Class<T> clazz) {
        String schemaUrn = SchemaUtils.getSchemaUrn(clazz);
        if (schemaUrn == null) {
            throw new IllegalArgumentException("Unable to determine the extension class schema.");
        }
        return schemaUrn;
    }

    public void addExtensionValue(@Nullable String path, @NotNull ArrayNode values) throws ScimException {
        this.addExtensionValue(Path.fromString(path), values);
    }

    public void addExtensionValue(@Nullable Path path, @NotNull ArrayNode values) throws ScimException {
        JsonUtils.addValue(path, this.extensionObjectNode, (JsonNode)values);
    }

    public boolean removeExtensionValues(@Nullable String path) throws ScimException {
        return this.removeExtensionValues(Path.fromString(path));
    }

    public boolean removeExtensionValues(@NotNull Path path) throws ScimException {
        List<JsonNode> nodes = JsonUtils.removeValues(path, this.extensionObjectNode);
        return !nodes.isEmpty();
    }

    @Override
    @NotNull
    public GenericScimResource asGenericScimResource() {
        ObjectNode object = (ObjectNode)JsonUtils.valueToNode(this);
        return new GenericScimResource(object);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseScimResource that = (BaseScimResource)o;
        if (this.extensionObjectNode != null ? !this.extensionObjectNode.equals((Object)that.extensionObjectNode) : that.extensionObjectNode != null) {
            return false;
        }
        if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.meta != null ? !this.meta.equals(that.meta) : that.meta != null) {
            return false;
        }
        return this.schemaUrns.equals(that.schemaUrns);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
        result = 31 * result + (this.meta != null ? this.meta.hashCode() : 0);
        result = 31 * result + (this.schemaUrns != null ? this.schemaUrns.hashCode() : 0);
        result = 31 * result + (this.extensionObjectNode != null ? this.extensionObjectNode.hashCode() : 0);
        return result;
    }

    @NotNull
    public String toString() {
        try {
            return JsonUtils.getObjectWriter().withDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

