/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.client.requests;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.unboundid.scim2.client.ScimService;
import com.unboundid.scim2.client.SearchResultHandler;
import com.unboundid.scim2.client.requests.ListResponseBuilder;
import com.unboundid.scim2.client.requests.ResourceReturningRequestBuilder;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.messages.ListResponse;
import com.unboundid.scim2.common.messages.SearchRequest;
import com.unboundid.scim2.common.messages.SortOrder;
import com.unboundid.scim2.common.utils.JsonUtils;
import com.unboundid.scim2.common.utils.SchemaUtils;
import com.unboundid.scim2.common.utils.StaticUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public final class SearchRequestBuilder
extends ResourceReturningRequestBuilder<SearchRequestBuilder> {
    private String filter;
    private String sortBy;
    private SortOrder sortOrder;
    private Integer startIndex;
    private Integer count;

    public SearchRequestBuilder(WebTarget target) {
        super(target);
    }

    public SearchRequestBuilder filter(String filter) {
        this.filter = filter;
        return this;
    }

    public SearchRequestBuilder sort(String sortBy, SortOrder sortOrder) {
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        return this;
    }

    public SearchRequestBuilder page(int startIndex, int count) {
        this.startIndex = startIndex;
        this.count = count;
        return this;
    }

    @Override
    WebTarget buildTarget() {
        WebTarget target = super.buildTarget();
        if (this.filter != null) {
            target = target.queryParam("filter", new Object[]{this.filter});
        }
        if (this.sortBy != null && this.sortOrder != null) {
            target = target.queryParam("sortBy", new Object[]{this.sortBy});
            target = target.queryParam("sortOrder", new Object[]{this.sortOrder.getName()});
        }
        if (this.startIndex != null && this.count != null) {
            target = target.queryParam("startIndex", new Object[]{this.startIndex});
            target = target.queryParam("count", new Object[]{this.count});
        }
        return target;
    }

    public <T> ListResponse<T> invoke(Class<T> cls) throws ScimException {
        ListResponseBuilder listResponseBuilder = new ListResponseBuilder();
        this.invoke(false, listResponseBuilder, cls);
        return listResponseBuilder.build();
    }

    public <T> void invoke(SearchResultHandler<T> resultHandler, Class<T> cls) throws ScimException {
        this.invoke(false, resultHandler, cls);
    }

    public <T extends ScimResource> ListResponse<T> invokePost(Class<T> cls) throws ScimException {
        ListResponseBuilder listResponseBuilder = new ListResponseBuilder();
        this.invoke(true, listResponseBuilder, cls);
        return listResponseBuilder.build();
    }

    public <T> void invokePost(SearchResultHandler<T> resultHandler, Class<T> cls) throws ScimException {
        this.invoke(true, resultHandler, cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void invoke(boolean post, SearchResultHandler<T> resultHandler, Class<T> cls) throws ScimException {
        block24: {
            Response response;
            if (post) {
                Set attributeSet = null;
                Set excludedAttributeSet = null;
                if (this.attributes != null && this.attributes.size() > 0) {
                    if (!this.excluded) {
                        attributeSet = this.attributes;
                    } else {
                        excludedAttributeSet = this.attributes;
                    }
                }
                SearchRequest searchRequest = new SearchRequest(attributeSet, excludedAttributeSet, this.filter, this.sortBy, this.sortOrder, this.startIndex, this.count);
                Invocation.Builder builder = this.target().path(".search").request(new MediaType[]{ScimService.MEDIA_TYPE_SCIM_TYPE, MediaType.APPLICATION_JSON_TYPE});
                for (Map.Entry header : this.headers.entrySet()) {
                    builder = builder.header((String)header.getKey(), (Object)StaticUtils.listToString((List)((List)header.getValue()), (String)", "));
                }
                response = builder.post(Entity.entity((Object)searchRequest, (String)this.getContentType()));
            } else {
                response = this.buildRequest().get();
            }
            try {
                if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                    InputStream inputStream = (InputStream)response.readEntity(InputStream.class);
                    try {
                        JsonParser parser = JsonUtils.getObjectReader().getFactory().createParser(inputStream);
                        try {
                            parser.nextToken();
                            boolean stop = false;
                            block9: while (!stop && parser.nextToken() != JsonToken.END_OBJECT) {
                                String field = parser.getCurrentName();
                                parser.nextToken();
                                if (field.equals("schemas")) {
                                    parser.skipChildren();
                                    continue;
                                }
                                if (field.equals("totalResults")) {
                                    resultHandler.totalResults(parser.getIntValue());
                                    continue;
                                }
                                if (field.equals("startIndex")) {
                                    resultHandler.startIndex(parser.getIntValue());
                                    continue;
                                }
                                if (field.equals("itemsPerPage")) {
                                    resultHandler.itemsPerPage(parser.getIntValue());
                                    continue;
                                }
                                if (field.equals("Resources")) {
                                    while (parser.nextToken() != JsonToken.END_ARRAY) {
                                        if (resultHandler.resource(parser.readValueAs(cls))) continue;
                                        stop = true;
                                        continue block9;
                                    }
                                    continue;
                                }
                                if (SchemaUtils.isUrn((String)field)) {
                                    resultHandler.extension(field, (ObjectNode)parser.readValueAsTree());
                                    continue;
                                }
                                parser.nextToken();
                            }
                            break block24;
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            parser.close();
                        }
                    }
                    catch (IOException e) {
                        throw new ResponseProcessingException(response, (Throwable)e);
                    }
                }
                throw SearchRequestBuilder.toScimException(response);
            }
            finally {
                response.close();
            }
        }
    }
}

