/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TChannelUtilities {
    private static final Logger logger = LoggerFactory.getLogger(TChannelUtilities.class);
    public static final ByteBuf emptyByteBuf = Unpooled.EMPTY_BUFFER;

    private TChannelUtilities() {
    }

    public static int scoreAddr(@NotNull NetworkInterface iface, @NotNull InetAddress addr) {
        int score = 0;
        if (addr instanceof Inet4Address) {
            score += 300;
        }
        try {
            if (!iface.isLoopback() && !addr.isLoopbackAddress()) {
                score += 100;
                if (iface.isUp()) {
                    score += 100;
                }
            }
        }
        catch (SocketException e) {
            logger.error("Unable to score IP {} of interface {}", new Object[]{addr, iface, e});
        }
        return score;
    }

    public static InetAddress getCurrentIp() {
        InetAddress bestAddr = null;
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            int bestScore = -1;
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface iface = networkInterfaces.nextElement();
                Enumeration<InetAddress> addrs = iface.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    int score = TChannelUtilities.scoreAddr(iface, addr);
                    if (score < bestScore) continue;
                    bestScore = score;
                    bestAddr = addr;
                }
            }
        }
        catch (IOException e) {
            logger.error("Problem getting local IP", (Throwable)e);
        }
        return bestAddr;
    }
}

