/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.tracing;

import io.opentracing.Span;
import java.util.EmptyStackException;
import java.util.Stack;

public interface TracingContext {
    public void pushSpan(Span var1);

    public boolean hasSpan();

    public Span currentSpan() throws EmptyStackException;

    public Span popSpan() throws EmptyStackException;

    public void clear();

    public static class ThreadLocal
    implements TracingContext {
        private final java.lang.ThreadLocal<Stack<Span>> stack = new java.lang.ThreadLocal<Stack<Span>>(){

            @Override
            protected Stack<Span> initialValue() {
                return new Stack<Span>();
            }
        };

        private Stack<Span> stack() {
            return this.stack.get();
        }

        @Override
        public void pushSpan(Span span) {
            this.stack().push(span);
        }

        @Override
        public boolean hasSpan() {
            return !this.stack().isEmpty();
        }

        @Override
        public Span popSpan() {
            return this.stack().pop();
        }

        @Override
        public void clear() {
            this.stack().clear();
        }

        @Override
        public Span currentSpan() {
            return this.stack().peek();
        }
    }

    public static class Default
    implements TracingContext {
        @Override
        public void pushSpan(Span span) {
        }

        @Override
        public boolean hasSpan() {
            return false;
        }

        @Override
        public Span currentSpan() {
            throw new EmptyStackException();
        }

        @Override
        public Span popSpan() throws EmptyStackException {
            throw new EmptyStackException();
        }

        @Override
        public void clear() {
        }
    }
}

