/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.tracing;

import com.google.common.collect.ImmutableMap;
import com.uber.tchannel.api.handlers.TFutureCallback;
import com.uber.tchannel.handlers.OutRequest;
import com.uber.tchannel.messages.Request;
import com.uber.tchannel.messages.Response;
import com.uber.tchannel.tracing.PrefixedHeadersCarrier;
import com.uber.tchannel.tracing.RequestSpanInterceptor;
import com.uber.tchannel.tracing.TraceableRequest;
import com.uber.tchannel.tracing.TracingContext;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Tracing {
    private static final Logger logger = LoggerFactory.getLogger(Tracing.class);
    public static final String HEADER_KEY_PREFIX = "$tracing$";

    private Tracing() {
    }

    public static <V extends Response> void startOutboundSpan(@NotNull OutRequest<V> outRequest, @Nullable Tracer tracer, @Nullable TracingContext tracingContext) throws RuntimeException {
        if (tracer == null || tracingContext == null) {
            return;
        }
        Request request = outRequest.getRequest();
        Tracer.SpanBuilder builder = tracer.buildSpan(request.getEndpoint());
        if (tracingContext.hasSpan()) {
            builder.asChildOf(tracingContext.currentSpan().context());
        }
        builder.withTag(Tags.SPAN_KIND.getKey(), "client").withTag(Tags.PEER_SERVICE.getKey(), request.getService()).withTag("as", request.getArgScheme().name());
        final Span span = builder.startManual();
        if (tracingContext instanceof RequestSpanInterceptor) {
            try {
                ((RequestSpanInterceptor)((Object)tracingContext)).interceptOutbound(request, span);
            }
            catch (RuntimeException e) {
                span.log((Map)ImmutableMap.of((Object)"exception", (Object)e));
                span.finish();
                throw e;
            }
        }
        if (request instanceof TraceableRequest) {
            TraceableRequest traceableRequest = (TraceableRequest)((Object)request);
            Map<String, String> headers = traceableRequest.getHeaders();
            PrefixedHeadersCarrier carrier = new PrefixedHeadersCarrier(headers);
            try {
                tracer.inject(span.context(), Format.Builtin.TEXT_MAP, (Object)carrier);
                traceableRequest.setHeaders(headers);
            }
            catch (Exception e) {
                logger.error("Failed to inject span context into headers", (Throwable)e);
            }
        }
        outRequest.getFuture().addCallback(new TFutureCallback<V>(){

            @Override
            public void onResponse(Response response) {
                if (response.isError()) {
                    Tags.ERROR.set(span, Boolean.valueOf(true));
                    span.log(response.getError().getMessage());
                }
                span.finish();
            }
        });
    }

    @NotNull
    public static Span startInboundSpan(@NotNull Request request, @NotNull Tracer tracer, @NotNull TracingContext tracingContext) throws RuntimeException {
        tracingContext.clear();
        Tracer.SpanBuilder builder = tracer.buildSpan(request.getEndpoint());
        if (request instanceof TraceableRequest) {
            TraceableRequest traceableRequest = (TraceableRequest)((Object)request);
            Map<String, String> headers = traceableRequest.getHeaders();
            PrefixedHeadersCarrier carrier = new PrefixedHeadersCarrier(headers);
            try {
                builder.asChildOf(tracer.extract(Format.Builtin.TEXT_MAP, (Object)carrier));
                Map<String, String> nonTracingHeaders = carrier.getNonTracingHeaders();
                if (nonTracingHeaders.size() < headers.size()) {
                    traceableRequest.setHeaders(nonTracingHeaders);
                }
            }
            catch (RuntimeException e) {
                logger.error("Failed to extract span context from headers", (Throwable)e);
            }
        }
        builder.withTag(Tags.SPAN_KIND.getKey(), "server").withTag("as", request.getArgScheme().name());
        Map<String, String> transportHeaders = request.getTransportHeaders();
        if (transportHeaders != null && transportHeaders.containsKey("cn")) {
            builder.withTag(Tags.PEER_SERVICE.getKey(), transportHeaders.get("cn"));
        }
        Span span = builder.startManual();
        if (tracingContext instanceof RequestSpanInterceptor) {
            try {
                ((RequestSpanInterceptor)((Object)tracingContext)).interceptInbound(request, span);
            }
            catch (RuntimeException e) {
                span.log((Map)ImmutableMap.of((Object)"exception", (Object)e));
                span.finish();
                throw e;
            }
        }
        tracingContext.pushSpan(span);
        return span;
    }
}

