/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.tracing;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Maps;
import io.opentracing.propagation.TextMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class PrefixedHeadersCarrier
implements TextMap {
    private static final int MAX_CACHE_SIZE = 100;
    private static final Function<String, String> PREFIXED_KEYS = PrefixedHeadersCarrier.prefixedKeys("$tracing$");
    private static final Function<String, String> UNPREFIXED_KEYS = PrefixedHeadersCarrier.unprefixedKeys("$tracing$");
    private final Map<String, String> headers;
    private final String prefix;
    private final Function<String, String> encoder;
    private final Function<String, String> decoder;

    PrefixedHeadersCarrier(Map<String, String> headers) {
        this(headers, "$tracing$", PREFIXED_KEYS, UNPREFIXED_KEYS);
    }

    PrefixedHeadersCarrier(Map<String, String> headers, String prefix) {
        this(headers, prefix, PrefixedHeadersCarrier.prefixedKeys(prefix), PrefixedHeadersCarrier.unprefixedKeys(prefix));
    }

    private PrefixedHeadersCarrier(Map<String, String> headers, String prefix, Function<String, String> encoder, Function<String, String> decoder) {
        this.headers = headers;
        this.prefix = prefix;
        this.encoder = encoder;
        this.decoder = decoder;
    }

    @NotNull
    public Iterator<Map.Entry<String, String>> iterator() {
        final Iterator<Map.Entry<String, String>> iterator = this.headers.entrySet().iterator();
        return new AbstractIterator<Map.Entry<String, String>>(){

            protected Map.Entry<String, String> computeNext() {
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    if (!((String)entry.getKey()).startsWith(PrefixedHeadersCarrier.this.prefix)) continue;
                    return Maps.immutableEntry((Object)PrefixedHeadersCarrier.this.decoder.apply(entry.getKey()), entry.getValue());
                }
                return (Map.Entry)this.endOfData();
            }
        };
    }

    public void put(String key, String value) {
        this.headers.put((String)this.encoder.apply((Object)key), value);
    }

    Map<String, String> getNonTracingHeaders() {
        return Maps.filterKeys(this.headers, (Predicate)new Predicate<String>(){

            public boolean apply(String key) {
                return !key.startsWith(PrefixedHeadersCarrier.this.prefix);
            }
        });
    }

    private static Function<String, String> prefixedKeys(final String prefix) {
        return PrefixedHeadersCarrier.cachingTransformer(new Function<String, String>(){

            public String apply(String key) {
                return prefix + key;
            }
        });
    }

    private static Function<String, String> unprefixedKeys(final String prefix) {
        return PrefixedHeadersCarrier.cachingTransformer(new Function<String, String>(){

            public String apply(String key) {
                return key.substring(prefix.length());
            }
        });
    }

    private static Function<String, String> cachingTransformer(Function<String, String> transformer) {
        final LoadingCache cache = CacheBuilder.newBuilder().maximumSize(100L).build(CacheLoader.from(transformer));
        return new Function<String, String>(){

            public String apply(String key) {
                return (String)cache.getUnchecked((Object)key);
            }
        };
    }
}

