/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.tracing;

import com.uber.tchannel.tracing.TracingContext;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import java.util.EmptyStackException;
import org.jetbrains.annotations.NotNull;

public class OpenTracingContext
implements TracingContext {
    @NotNull
    private final ScopeManager scopeManager;

    public OpenTracingContext(@NotNull ScopeManager scopeManager) {
        this.scopeManager = scopeManager;
    }

    @Override
    public void pushSpan(@NotNull Span span) {
        this.scopeManager.activate(span, false);
    }

    @Override
    public boolean hasSpan() {
        return this.scopeManager.active() != null;
    }

    @Override
    @NotNull
    public Span currentSpan() throws EmptyStackException {
        Scope scope = this.scopeManager.active();
        if (scope == null) {
            throw new EmptyStackException();
        }
        return scope.span();
    }

    @Override
    @NotNull
    public Span popSpan() throws EmptyStackException {
        try (Scope scope = this.scopeManager.active();){
            if (scope == null) {
                throw new EmptyStackException();
            }
            Span span = scope.span();
            return span;
        }
    }

    @Override
    public void clear() {
        Scope scope;
        while ((scope = this.scopeManager.active()) != null) {
            scope.close();
        }
    }
}

