/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.messages;

import com.uber.tchannel.codecs.CodecUtils;
import com.uber.tchannel.messages.Serializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftSerializer
implements Serializer.SerializerInterface {
    private static final Logger logger = LoggerFactory.getLogger(ThriftSerializer.class);

    @Override
    @NotNull
    public String decodeEndpoint(@NotNull ByteBuf arg1) {
        return arg1.toString(CharsetUtil.UTF_8);
    }

    @Override
    @NotNull
    public Map<String, String> decodeHeaders(@NotNull ByteBuf arg2) {
        return CodecUtils.decodeHeaders(arg2);
    }

    @Override
    @Nullable
    public <T> T decodeBody(@NotNull ByteBuf arg3, @NotNull Class<T> bodyType) {
        try {
            T base = bodyType.getConstructor(new Class[0]).newInstance(new Object[0]);
            byte[] payloadBytes = new byte[arg3.readableBytes()];
            arg3.readBytes(payloadBytes);
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
            deserializer.deserialize((TBase)base, payloadBytes);
            return base;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | TException e) {
            logger.error("Failed to decode body to {}", (Object)bodyType.getName(), (Object)e);
            return null;
        }
    }

    @Override
    public ByteBuf encodeEndpoint(@NotNull String method) {
        return Unpooled.wrappedBuffer((byte[])method.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public ByteBuf encodeHeaders(@NotNull Map<String, String> applicationHeaders) {
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer();
        CodecUtils.encodeHeaders(applicationHeaders, buf);
        return buf;
    }

    @Override
    @Nullable
    public ByteBuf encodeBody(@NotNull Object body) {
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
            byte[] payloadBytes = serializer.serialize((TBase)body);
            return Unpooled.wrappedBuffer((byte[])payloadBytes);
        }
        catch (TException e) {
            logger.error("Failed to encode {} body", (Object)body.getClass().getName(), (Object)e);
            return null;
        }
    }
}

