/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.messages;

import com.uber.tchannel.headers.ArgScheme;
import com.uber.tchannel.messages.EncodedRequest;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ThriftRequest<T>
extends EncodedRequest<T> {
    private ThriftRequest(Builder<T> builder) {
        super(builder);
    }

    protected ThriftRequest(long id, long ttl, String service, Map<String, String> transportHeaders, ByteBuf arg1, ByteBuf arg2, ByteBuf arg3) {
        super(id, ttl, service, transportHeaders, arg1, arg2, arg3);
    }

    public static class Builder<T>
    extends EncodedRequest.Builder<T> {
        public Builder(String service, String endpoint) {
            super(service, endpoint);
            this.transportHeaders.put("as", ArgScheme.THRIFT.getScheme());
            this.argScheme = ArgScheme.THRIFT;
        }

        public Builder(String service, ByteBuf arg1) {
            super(service, arg1);
            this.transportHeaders.put("as", ArgScheme.THRIFT.getScheme());
            this.argScheme = ArgScheme.THRIFT;
        }

        @Override
        public Builder<T> validate() {
            super.validate();
            return this;
        }

        public ThriftRequest<T> build() {
            return new ThriftRequest((Builder)this.validate());
        }

        @Override
        public Builder<T> setTimeout(long timeoutMillis) {
            super.setTimeout(timeoutMillis);
            return this;
        }

        @Override
        public Builder<T> setTimeout(long timeout, TimeUnit timeUnit) {
            super.setTimeout(timeout, timeUnit);
            return this;
        }

        @Override
        public Builder<T> setId(long id) {
            super.setId(id);
            return this;
        }

        @Override
        public Builder<T> setArg2(ByteBuf arg2) {
            super.setArg2(arg2);
            return this;
        }

        @Override
        public Builder<T> setArg3(ByteBuf arg3) {
            super.setArg3(arg3);
            return this;
        }

        @Override
        public Builder<T> setHeader(String key, String value) {
            super.setHeader(key, value);
            return this;
        }

        @Override
        public Builder<T> setHeaders(Map<String, String> headers) {
            super.setHeaders(headers);
            return this;
        }

        @Override
        public Builder<T> setBody(T body) {
            super.setBody(body);
            return this;
        }

        @Override
        public Builder<T> setTransportHeader(String key, String value) {
            super.setTransportHeader(key, value);
            return this;
        }

        @Override
        public Builder<T> setTransportHeaders(Map<String, String> transportHeaders) {
            super.setTransportHeaders(transportHeaders);
            return this;
        }

        @Override
        public Builder<T> setRetryLimit(int retryLimit) {
            super.setRetryLimit(retryLimit);
            return this;
        }
    }
}

