/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.messages;

import com.uber.tchannel.headers.ArgScheme;
import com.uber.tchannel.messages.RawMessage;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Serializer {
    Map<ArgScheme, SerializerInterface> serializers;

    public Serializer(Map<ArgScheme, SerializerInterface> serializers) {
        this.serializers = serializers;
    }

    public String decodeEndpoint(RawMessage message) {
        return this.getSerializer(message).decodeEndpoint(message.getArg1());
    }

    public Map<String, String> decodeHeaders(RawMessage message) {
        return this.getSerializer(message).decodeHeaders(message.getArg2());
    }

    public <T> T decodeBody(RawMessage message, Class<T> bodyType) {
        return this.getSerializer(message).decodeBody(message.getArg3(), bodyType);
    }

    public ByteBuf encodeEndpoint(String method, ArgScheme argScheme) {
        return this.getSerializer(argScheme).encodeEndpoint(method);
    }

    public ByteBuf encodeHeaders(Map<String, String> applicationHeaders, ArgScheme argScheme) {
        return this.getSerializer(argScheme).encodeHeaders(applicationHeaders);
    }

    public ByteBuf encodeBody(Object body, ArgScheme argScheme) {
        return this.getSerializer(argScheme).encodeBody(body);
    }

    private SerializerInterface getSerializer(RawMessage message) {
        Map<String, String> transportHeaders = message.getTransportHeaders();
        ArgScheme argScheme = ArgScheme.toScheme(transportHeaders.get("as"));
        return this.serializers.get((Object)argScheme);
    }

    private SerializerInterface getSerializer(ArgScheme argScheme) {
        return this.serializers.get((Object)argScheme);
    }

    public static interface SerializerInterface {
        @NotNull
        public String decodeEndpoint(@NotNull ByteBuf var1);

        @NotNull
        public Map<String, String> decodeHeaders(@NotNull ByteBuf var1);

        @Nullable
        public <T> T decodeBody(@NotNull ByteBuf var1, @NotNull Class<T> var2);

        public ByteBuf encodeEndpoint(String var1);

        public ByteBuf encodeHeaders(Map<String, String> var1);

        public ByteBuf encodeBody(Object var1);
    }
}

