/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.messages;

import com.uber.tchannel.api.ResponseCode;
import com.uber.tchannel.errors.ErrorType;
import com.uber.tchannel.frames.FrameType;
import com.uber.tchannel.headers.ArgScheme;
import com.uber.tchannel.messages.ErrorResponse;
import com.uber.tchannel.messages.JsonResponse;
import com.uber.tchannel.messages.RawMessage;
import com.uber.tchannel.messages.RawResponse;
import com.uber.tchannel.messages.Request;
import com.uber.tchannel.messages.ResponseMessage;
import com.uber.tchannel.messages.ThriftResponse;
import com.uber.tchannel.utils.TChannelUtilities;
import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Response
extends ResponseMessage
implements RawMessage {
    @NotNull
    private static final ByteBuf arg1 = TChannelUtilities.emptyByteBuf;
    @Nullable
    protected ByteBuf arg2;
    @Nullable
    protected ByteBuf arg3;
    protected long id;
    @Nullable
    protected final ResponseCode responseCode;
    @Nullable
    protected final Map<String, String> transportHeaders;
    @Nullable
    private final ErrorResponse error;

    protected Response(long id, ResponseCode responseCode, Map<String, String> transportHeaders, ByteBuf arg2, ByteBuf arg3) {
        this.id = id;
        this.responseCode = responseCode;
        this.transportHeaders = transportHeaders;
        this.arg2 = arg2;
        this.arg3 = arg3;
        this.type = FrameType.CallResponse;
        this.error = null;
    }

    protected Response(@NotNull Builder builder) {
        this.id = builder.id;
        this.responseCode = builder.responseCode;
        this.transportHeaders = builder.transportHeaders;
        this.arg2 = builder.arg2;
        this.arg3 = builder.arg3;
        this.type = FrameType.CallResponse;
        this.error = null;
    }

    protected Response(@NotNull ErrorResponse error) {
        this.id = error.getId();
        this.responseCode = null;
        this.transportHeaders = null;
        this.arg2 = null;
        this.arg3 = null;
        this.type = FrameType.Error;
        this.error = error;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Nullable
    public ResponseCode getResponseCode() {
        return this.responseCode;
    }

    @Override
    @Nullable
    public Map<String, String> getTransportHeaders() {
        return this.transportHeaders;
    }

    @Override
    @NotNull
    public ByteBuf getArg1() {
        return arg1;
    }

    @Override
    @Nullable
    public ByteBuf getArg2() {
        return this.arg2;
    }

    @Override
    @Nullable
    public ByteBuf getArg3() {
        return this.arg3;
    }

    public String toString() {
        return String.format("<%s id=%d transportHeaders=%s arg1=%s arg2=%s arg3=%s>", this.getClass().getSimpleName(), this.id, this.transportHeaders, arg1.toString(CharsetUtil.UTF_8), this.arg2 == null ? null : this.arg2.toString(CharsetUtil.UTF_8), this.arg3 == null ? null : this.arg3.toString(CharsetUtil.UTF_8));
    }

    @Override
    public void release() {
        arg1.release();
        if (this.arg2 != null) {
            this.arg2.release();
            this.arg2 = null;
        }
        if (this.arg3 != null) {
            this.arg3.release();
            this.arg3 = null;
        }
    }

    @Override
    public boolean isError() {
        return this.type == FrameType.Error || this.getError() != null;
    }

    @Nullable
    public ErrorResponse getError() {
        return this.error;
    }

    public ArgScheme getArgScheme() {
        return ArgScheme.toScheme(this.transportHeaders.get("as"));
    }

    public int argSize() {
        return (this.arg2 == null ? 0 : this.arg2.readableBytes()) + (this.arg3 == null ? 0 : this.arg3.readableBytes());
    }

    @Nullable
    public static Response build(long id, ResponseCode responseCode, @NotNull Map<String, String> transportHeaders, ByteBuf arg2, ByteBuf arg3) {
        ArgScheme argScheme = ArgScheme.toScheme(transportHeaders.get("as"));
        if (argScheme == null) {
            return null;
        }
        return Response.build(argScheme, id, responseCode, transportHeaders, arg2, arg3);
    }

    @Nullable
    public static Response build(@NotNull ArgScheme argScheme, long id, ResponseCode responseCode, Map<String, String> transportHeaders, ByteBuf arg2, ByteBuf arg3) {
        Response res;
        switch (argScheme) {
            case RAW: {
                res = new RawResponse(id, responseCode, transportHeaders, arg2, arg3);
                break;
            }
            case JSON: {
                res = new JsonResponse(id, responseCode, transportHeaders, arg2, arg3);
                break;
            }
            case THRIFT: {
                res = new ThriftResponse(id, responseCode, transportHeaders, arg2, arg3);
                break;
            }
            default: {
                res = null;
            }
        }
        return res;
    }

    @NotNull
    public static Response build(@NotNull ArgScheme argScheme, long id, ErrorType errorType, String message) {
        return Response.build(argScheme, new ErrorResponse(id, errorType, message));
    }

    @NotNull
    public static Response build(@NotNull ArgScheme argScheme, ErrorResponse errorResponse) {
        Response res;
        switch (argScheme) {
            case RAW: {
                res = new RawResponse(errorResponse);
                break;
            }
            case JSON: {
                res = new JsonResponse(errorResponse);
                break;
            }
            case THRIFT: {
                res = new ThriftResponse(errorResponse);
                break;
            }
            default: {
                res = new RawResponse(errorResponse);
            }
        }
        return res;
    }

    public static class Builder {
        @NotNull
        protected Map<String, String> transportHeaders = new HashMap<String, String>();
        protected ByteBuf arg2 = null;
        protected ByteBuf arg3 = null;
        protected ResponseCode responseCode = ResponseCode.OK;
        private long id = -1L;

        public Builder(@NotNull Request req) {
            this.id = req.getId();
            this.transportHeaders.put("as", req.getTransportHeaders().get("as"));
        }

        @NotNull
        public Builder setResponseCode(ResponseCode responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        @NotNull
        public Builder setArg2(ByteBuf arg2) {
            if (this.arg2 != null) {
                this.arg2.release();
            }
            this.arg2 = arg2;
            return this;
        }

        @NotNull
        public Builder setArg3(ByteBuf arg3) {
            if (this.arg3 != null) {
                this.arg3.release();
            }
            this.arg3 = arg3;
            return this;
        }

        @NotNull
        public Builder setTransportHeader(String key, String value) {
            this.transportHeaders.put(key, value);
            return this;
        }

        @NotNull
        public Builder setTransportHeaders(@NotNull Map<String, String> transportHeaders) {
            this.transportHeaders = transportHeaders;
            return this;
        }

        @NotNull
        public Builder setId(long id) {
            this.id = id;
            return this;
        }

        @NotNull
        public Builder validate() {
            return this;
        }
    }
}

