/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.messages;

import com.uber.tchannel.headers.ArgScheme;
import com.uber.tchannel.messages.Request;
import com.uber.tchannel.utils.TChannelUtilities;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class RawRequest
extends Request {
    private String header = null;
    private String body = null;

    protected RawRequest(Builder builder) {
        super(builder);
        this.body = builder.body;
        this.header = builder.header;
    }

    protected RawRequest(long id, long ttl, String service, Map<String, String> transportHeaders, ByteBuf arg1, ByteBuf arg2, ByteBuf arg3) {
        super(id, ttl, service, transportHeaders, arg1, arg2, arg3);
    }

    public String getHeader() {
        if (this.header == null) {
            this.header = this.arg2 == null ? "" : this.arg2.toString(CharsetUtil.UTF_8);
        }
        return this.header;
    }

    public String getBody() {
        if (this.body == null) {
            this.body = this.arg3 == null ? "" : this.arg3.toString(CharsetUtil.UTF_8);
        }
        return this.body;
    }

    public static class Builder
    extends Request.Builder {
        protected String header = null;
        protected String body = null;

        public Builder(String service, String endpoint) {
            super(service, endpoint);
            this.transportHeaders.put("as", ArgScheme.RAW.getScheme());
        }

        public Builder(String service, ByteBuf arg1) {
            super(service, arg1);
            this.transportHeaders.put("as", ArgScheme.RAW.getScheme());
        }

        @Override
        public Builder setTimeout(long timeoutMillis) {
            super.setTimeout(timeoutMillis);
            return this;
        }

        @Override
        public Builder setTimeout(long timeout, TimeUnit timeUnit) {
            super.setTimeout(timeout, timeUnit);
            return this;
        }

        @Override
        public Builder setId(long id) {
            super.setId(id);
            return this;
        }

        @Override
        public Builder setRetryLimit(int retryLimit) {
            super.setRetryLimit(retryLimit);
            return this;
        }

        @Override
        public Builder setArg2(ByteBuf arg2) {
            super.setArg2(arg2);
            this.header = null;
            return this;
        }

        @Override
        public Builder setArg3(ByteBuf arg3) {
            super.setArg3(arg3);
            this.body = null;
            return this;
        }

        @Override
        public Builder setTransportHeader(String key, String value) {
            super.setTransportHeader(key, value);
            return this;
        }

        @Override
        public Builder setTransportHeaders(Map<String, String> transportHeaders) {
            super.setTransportHeaders(transportHeaders);
            return this;
        }

        public final Builder setHeader(String header) {
            this.setArg2(Unpooled.wrappedBuffer((byte[])header.getBytes(StandardCharsets.UTF_8)));
            this.header = header;
            return this;
        }

        public final Builder setBody(String body) {
            this.setArg3(Unpooled.wrappedBuffer((byte[])body.getBytes(StandardCharsets.UTF_8)));
            this.body = body;
            return this;
        }

        @Override
        public Builder validate() {
            super.validate();
            if (this.arg2 == null) {
                this.arg2 = TChannelUtilities.emptyByteBuf;
            }
            if (this.arg3 == null) {
                this.arg3 = TChannelUtilities.emptyByteBuf;
            }
            return this;
        }

        public RawRequest build() {
            return new RawRequest(this.validate());
        }
    }
}

