/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.messages;

import com.uber.tchannel.api.ResponseCode;
import com.uber.tchannel.headers.ArgScheme;
import com.uber.tchannel.messages.EncodedResponse;
import com.uber.tchannel.messages.ErrorResponse;
import com.uber.tchannel.messages.JsonRequest;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class JsonResponse<T>
extends EncodedResponse<T> {
    private JsonResponse(Builder<T> builder) {
        super(builder);
    }

    protected JsonResponse(long id, ResponseCode responseCode, Map<String, String> transportHeaders, ByteBuf arg2, ByteBuf arg3) {
        super(id, responseCode, transportHeaders, arg2, arg3);
    }

    protected JsonResponse(ErrorResponse error) {
        super(error);
    }

    public static class Builder<T>
    extends EncodedResponse.Builder<T> {
        public Builder(@NotNull JsonRequest<?> req) {
            super(req);
            this.argScheme = ArgScheme.JSON;
        }

        @Override
        @NotNull
        public Builder<T> validate() {
            super.validate();
            return this;
        }

        @NotNull
        public JsonResponse<T> build() {
            return new JsonResponse((Builder)this.validate());
        }

        @Override
        @NotNull
        public Builder<T> setArg2(ByteBuf arg2) {
            super.setArg2(arg2);
            return this;
        }

        @Override
        @NotNull
        public Builder<T> setArg3(ByteBuf arg3) {
            super.setArg3(arg3);
            return this;
        }

        @Override
        @NotNull
        public Builder<T> setHeader(String key, String value) {
            super.setHeader(key, value);
            return this;
        }

        @Override
        @NotNull
        public Builder<T> setHeaders(Map<String, String> headers) {
            super.setHeaders(headers);
            return this;
        }

        @Override
        @NotNull
        public Builder<T> setBody(T body) {
            super.setBody(body);
            return this;
        }

        @Override
        @NotNull
        public Builder<T> setTransportHeader(String key, String value) {
            super.setTransportHeader(key, value);
            return this;
        }

        @Override
        @NotNull
        public Builder<T> setTransportHeaders(@NotNull Map<String, String> transportHeaders) {
            super.setTransportHeaders(transportHeaders);
            return this;
        }

        @Override
        @NotNull
        public Builder<T> setResponseCode(ResponseCode responseCode) {
            super.setResponseCode(responseCode);
            return this;
        }
    }
}

