/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.messages;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.uber.tchannel.messages.Serializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class JSONSerializer
implements Serializer.SerializerInterface {
    private static final Type HEADER_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Gson GSON = new Gson();

    @Override
    @NotNull
    public String decodeEndpoint(@NotNull ByteBuf arg1) {
        return arg1.toString(CharsetUtil.UTF_8);
    }

    @Override
    @NotNull
    public Map<String, String> decodeHeaders(@NotNull ByteBuf arg2) {
        String headerJSON = arg2.toString(CharsetUtil.UTF_8);
        Map headers = null;
        if (headerJSON != null && !headerJSON.isEmpty() && !"\"\"".equals(headerJSON)) {
            headers = (Map)new Gson().fromJson(headerJSON, HEADER_TYPE);
        }
        return headers == null ? new HashMap() : headers;
    }

    @Override
    public <T> T decodeBody(@NotNull ByteBuf arg3, @NotNull Class<T> bodyType) {
        String bodyJSON = arg3.toString(CharsetUtil.UTF_8);
        return (T)GSON.fromJson(bodyJSON, bodyType);
    }

    @Override
    public ByteBuf encodeEndpoint(String method) {
        return Unpooled.wrappedBuffer((byte[])method.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public ByteBuf encodeHeaders(Map<String, String> applicationHeaders) {
        return Unpooled.wrappedBuffer((byte[])GSON.toJson(applicationHeaders, HEADER_TYPE).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public ByteBuf encodeBody(Object body) {
        return Unpooled.wrappedBuffer((byte[])GSON.toJson(body).getBytes(StandardCharsets.UTF_8));
    }
}

