/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.messages;

import com.google.common.collect.ImmutableMap;
import com.uber.tchannel.api.ResponseCode;
import com.uber.tchannel.headers.ArgScheme;
import com.uber.tchannel.messages.ErrorResponse;
import com.uber.tchannel.messages.JSONSerializer;
import com.uber.tchannel.messages.Request;
import com.uber.tchannel.messages.Response;
import com.uber.tchannel.messages.Serializer;
import com.uber.tchannel.messages.ThriftSerializer;
import com.uber.tchannel.utils.TChannelUtilities;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class EncodedResponse<T>
extends Response {
    private static final ImmutableMap<ArgScheme, Serializer.SerializerInterface> DEFAULT_SERIALIZERS = ImmutableMap.of((Object)((Object)ArgScheme.JSON), (Object)new JSONSerializer(), (Object)((Object)ArgScheme.THRIFT), (Object)new ThriftSerializer());
    private static final Serializer serializer = new Serializer((Map<ArgScheme, Serializer.SerializerInterface>)DEFAULT_SERIALIZERS);
    protected Map<String, String> headers;
    protected T body = null;

    protected EncodedResponse(@NotNull Builder<T> builder) {
        super(builder);
        this.headers = ((Builder)builder).headers;
        this.body = ((Builder)builder).body;
    }

    protected EncodedResponse(long id, ResponseCode responseCode, Map<String, String> transportHeaders, ByteBuf arg2, ByteBuf arg3) {
        super(id, responseCode, transportHeaders, arg2, arg3);
    }

    protected EncodedResponse(@NotNull ErrorResponse error) {
        super(error);
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            if (this.arg2 == null) {
                return new HashMap<String, String>();
            }
            this.headers = serializer.decodeHeaders(this);
        }
        return this.headers;
    }

    public String getHeader(String key) {
        return this.getHeaders().get(key);
    }

    public T getBody(Class<T> bodyType) {
        if (this.body == null && this.arg3 != null) {
            this.body = serializer.decodeBody(this, bodyType);
        }
        return this.body;
    }

    @Override
    public String toString() {
        if (this.isError()) {
            return this.getError().toString();
        }
        return String.format("<%s responseCode=%s transportHeaders=%s headers=%s body=%s>", new Object[]{this.getClass().getSimpleName(), this.responseCode, this.transportHeaders, this.headers, this.body});
    }

    public static class Builder<T>
    extends Response.Builder {
        private Map<String, String> headers = new HashMap<String, String>();
        private T body;
        protected ArgScheme argScheme;

        public Builder(@NotNull Request req) {
            super(req);
        }

        @Override
        @NotNull
        public Builder<T> setArg2(ByteBuf arg2) {
            if (arg2 != null && !this.headers.isEmpty()) {
                throw new IllegalStateException("Cannot set both `arg2` and `headers`.");
            }
            super.setArg2(arg2);
            return this;
        }

        @Override
        @NotNull
        public Builder<T> setArg3(ByteBuf arg3) {
            if (arg3 != null && this.body != null) {
                throw new IllegalStateException("Cannot set both `arg3` and `body`.");
            }
            super.setArg3(arg3);
            return this;
        }

        @NotNull
        public Builder<T> setHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        @NotNull
        public Builder<T> setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        @NotNull
        public Builder<T> setBody(T body) {
            this.body = body;
            return this;
        }

        @NotNull
        private Builder<T> validateHeader() {
            if (this.arg2 == null) {
                this.arg2 = serializer.encodeHeaders(this.headers, this.argScheme);
            } else {
                this.headers = null;
            }
            return this;
        }

        @NotNull
        private Builder<T> validateBody() {
            if (this.arg3 == null) {
                this.arg3 = this.body == null ? TChannelUtilities.emptyByteBuf : serializer.encodeBody(this.body, this.argScheme);
            } else {
                this.body = null;
            }
            return this;
        }

        @Override
        @NotNull
        public Builder<T> validate() throws IllegalStateException {
            super.validate();
            this.validateHeader();
            this.validateBody();
            if (this.responseCode == null) {
                throw new IllegalStateException("`responseCode` cannot be null.");
            }
            return this;
        }
    }
}

