/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.headers;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum RetryFlag {
    NoRetry('n'),
    RetryOnConnectionError('c'),
    RetryOnTimeout('t');

    private final char flag;

    private RetryFlag(char flag) {
        this.flag = flag;
    }

    @Nullable
    public static RetryFlag toRetryFlag(char c) {
        switch (c) {
            case 'n': {
                return NoRetry;
            }
            case 'c': {
                return RetryOnConnectionError;
            }
            case 't': {
                return RetryOnTimeout;
            }
        }
        return null;
    }

    @NotNull
    public static Set<RetryFlag> parseFlags(@NotNull String flags) {
        HashSet<RetryFlag> retryFlags = new HashSet<RetryFlag>();
        for (char c : flags.toCharArray()) {
            retryFlags.add(RetryFlag.toRetryFlag(c));
        }
        return retryFlags;
    }

    @NotNull
    public static String flagsToString(@NotNull Set<RetryFlag> flags) {
        StringBuilder sb = new StringBuilder();
        for (RetryFlag flag : flags) {
            sb.append(flag.toString());
        }
        return sb.toString();
    }

    public static boolean validFlags(@NotNull String flags) {
        switch (flags) {
            case "c": 
            case "t": 
            case "n": 
            case "ct": 
            case "tc": {
                return true;
            }
        }
        return false;
    }

    public char getFlag() {
        return this.flag;
    }
}

