/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.headers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ArgScheme {
    RAW("raw"),
    JSON("json"),
    HTTP("http"),
    THRIFT("thrift"),
    STREAMING_THRIFT("sthrift");

    @NotNull
    private final String scheme;

    private ArgScheme(String scheme) {
        this.scheme = scheme;
    }

    @Nullable
    public static ArgScheme toScheme(@Nullable String argScheme) {
        if (argScheme == null) {
            return null;
        }
        switch (argScheme) {
            case "raw": {
                return RAW;
            }
            case "json": {
                return JSON;
            }
            case "http": {
                return HTTP;
            }
            case "thrift": {
                return THRIFT;
            }
            case "sthrift": {
                return STREAMING_THRIFT;
            }
        }
        return null;
    }

    public static boolean isSupported(@Nullable ArgScheme scheme) {
        if (scheme == null) {
            return false;
        }
        switch (scheme) {
            case RAW: 
            case JSON: 
            case THRIFT: {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getScheme() {
        return this.scheme;
    }
}

