/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.handlers;

import com.uber.tchannel.api.TChannel;
import com.uber.tchannel.api.errors.TChannelConnectionReset;
import com.uber.tchannel.channels.PeerManager;
import com.uber.tchannel.errors.ErrorType;
import com.uber.tchannel.handlers.OutRequest;
import com.uber.tchannel.messages.ErrorResponse;
import com.uber.tchannel.messages.Request;
import com.uber.tchannel.messages.ResponseMessage;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseRouter
extends SimpleChannelInboundHandler<ResponseMessage> {
    private static final Logger logger = LoggerFactory.getLogger(ResponseRouter.class);
    @NotNull
    private final PeerManager peerManager;
    @NotNull
    private final HashedWheelTimer timer;
    @NotNull
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final int resetOnTimeoutLimit;
    @NotNull
    private final AtomicInteger timeouts = new AtomicInteger(0);
    @NotNull
    private final AtomicBoolean busy = new AtomicBoolean(false);
    @NotNull
    private final ConcurrentLinkedQueue<Long> requestQueue = new ConcurrentLinkedQueue();
    @NotNull
    private final Map<Long, OutRequest<?>> requestMap = new ConcurrentHashMap();
    private final int maxPendingRequests;
    @NotNull
    private final AtomicInteger idGenerator = new AtomicInteger(0);
    private ChannelHandlerContext ctx;

    public ResponseRouter(@NotNull TChannel topChannel, @NotNull HashedWheelTimer timer) {
        this.peerManager = topChannel.getPeerManager();
        this.resetOnTimeoutLimit = topChannel.getResetOnTimeoutLimit();
        this.timer = timer;
        this.maxPendingRequests = topChannel.getClientMaxPendingRequests();
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.ctx = ctx;
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        this.sendRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendRequest() {
        if (!this.busy.compareAndSet(false, true)) {
            return;
        }
        Channel channel = this.ctx.channel();
        try {
            boolean flush = false;
            while (!this.requestQueue.isEmpty() && channel.isWritable()) {
                long id = this.requestQueue.poll();
                OutRequest<?> outRequest = this.requestMap.get(id);
                if (outRequest == null) continue;
                outRequest.setChannelFuture(channel.write((Object)outRequest.getRequest()));
                flush = true;
            }
            if (flush) {
                channel.flush();
            }
        }
        finally {
            this.busy.set(false);
        }
        if (channel.isWritable() && !this.requestQueue.isEmpty()) {
            this.sendRequest();
        }
    }

    public boolean expectResponse(@NotNull OutRequest<?> outRequest) {
        int messageId = this.idGenerator.incrementAndGet();
        Request request = outRequest.getRequest();
        request.setId(messageId);
        if (this.destroyed.get()) {
            outRequest.setLastError(ErrorType.NetworkError, "Connection already closed");
            return false;
        }
        if (this.requestMap.size() + this.requestQueue.size() > this.maxPendingRequests) {
            outRequest.setLastError(ErrorType.Busy, String.format("Client max pending request limit of %d is reached", this.maxPendingRequests));
            return false;
        }
        return this.send(outRequest);
    }

    protected boolean send(@NotNull OutRequest<?> outRequest) {
        Request request = outRequest.getRequest();
        this.requestMap.put(request.getId(), outRequest);
        this.setTimer(outRequest);
        if (!this.ctx.channel().isActive()) {
            this.handleResponse(new ErrorResponse(outRequest.getRequest().getId(), ErrorType.NetworkError, "Channel is closed"));
            return false;
        }
        this.requestQueue.offer(outRequest.getRequest().getId());
        this.sendRequest();
        return true;
    }

    protected void setTimer(final @NotNull OutRequest<?> outRequest) {
        final long start = System.currentTimeMillis();
        Timeout timeout = this.timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                outRequest.flushWrite();
                if (ResponseRouter.this.timeouts.incrementAndGet() >= ResponseRouter.this.resetOnTimeoutLimit) {
                    ResponseRouter.this.peerManager.handleConnectionErrors(ResponseRouter.this.ctx.channel(), new TChannelConnectionReset(String.format("Connection reset due to continuous %d timeouts", ResponseRouter.this.resetOnTimeoutLimit)));
                    return;
                }
                ResponseRouter.this.handleResponse(new ErrorResponse(outRequest.getRequest().getId(), ErrorType.Timeout, String.format("Request timeout after %dms", System.currentTimeMillis() - start)));
            }
        }, outRequest.getRequest().getTimeout(), TimeUnit.MILLISECONDS);
        outRequest.setTimeout(timeout);
    }

    protected void handleResponse(@NotNull ResponseMessage response) {
        OutRequest<?> outRequest = this.requestMap.remove(response.getId());
        if (outRequest == null) {
            response.release();
            return;
        }
        outRequest.handleResponse(response);
    }

    protected void channelRead0(ChannelHandlerContext ctx, @NotNull ResponseMessage response) {
        this.handleResponse(response);
    }

    public void clean() {
        if (!this.destroyed.compareAndSet(false, true)) {
            return;
        }
        this.clean(this.requestMap.keySet());
        this.clean(this.requestQueue);
    }

    private void clean(@NotNull Iterable<Long> keys) {
        for (long key : keys) {
            OutRequest<?> outRequest = this.requestMap.remove(key);
            if (outRequest == null) continue;
            outRequest.flushWrite();
            outRequest.setLastError(ErrorType.NetworkError, "Connection was reset due to network error");
            outRequest.setFuture();
        }
    }
}

