/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.handlers;

import com.uber.tchannel.api.SubChannel;
import com.uber.tchannel.api.TFuture;
import com.uber.tchannel.errors.ErrorType;
import com.uber.tchannel.headers.ArgScheme;
import com.uber.tchannel.messages.ErrorResponse;
import com.uber.tchannel.messages.JsonResponse;
import com.uber.tchannel.messages.RawResponse;
import com.uber.tchannel.messages.Request;
import com.uber.tchannel.messages.Response;
import com.uber.tchannel.messages.ResponseMessage;
import com.uber.tchannel.messages.ThriftResponse;
import com.uber.tchannel.tracing.TracingContext;
import io.netty.channel.ChannelFuture;
import io.netty.util.Timeout;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutRequest<V extends Response> {
    private static final Logger logger = LoggerFactory.getLogger(OutRequest.class);
    @NotNull
    private final SubChannel subChannel;
    @NotNull
    private final Request request;
    @NotNull
    private final TFuture<V> future;
    @NotNull
    private final Set<SocketAddress> usedPeers = new HashSet<SocketAddress>();
    @NotNull
    private final AtomicInteger retryCount = new AtomicInteger(0);
    private int retryLimit = 0;
    @Nullable
    private Timeout timeout = null;
    @Nullable
    private ChannelFuture channelFuture = null;
    @Nullable
    private ErrorResponse lastError = null;

    public OutRequest(@NotNull SubChannel subChannel, @NotNull Request request, @Nullable TracingContext tracingContext) {
        this.subChannel = subChannel;
        this.request = request;
        this.future = TFuture.create(request.getArgScheme(), tracingContext);
        this.retryLimit = request.getRetryLimit();
    }

    @Deprecated
    public OutRequest(@NotNull SubChannel subChannel, @NotNull Request request) {
        this(subChannel, request, null);
    }

    @NotNull
    public Request getRequest() {
        return this.request;
    }

    @NotNull
    public TFuture<V> getFuture() {
        return this.future;
    }

    public int getRetryCount() {
        return this.retryCount.get();
    }

    public void disableRetry() {
        this.retryLimit = 0;
        this.retryCount.set(1);
    }

    public boolean shouldRetry() {
        int count = this.retryCount.getAndIncrement();
        if (count > this.retryLimit) {
            return false;
        }
        if (count == 0) {
            return true;
        }
        return this.shouldRetryOnError();
    }

    @Nullable
    public Timeout getTimeout() {
        return this.timeout;
    }

    public void setTimeout(@Nullable Timeout timeout) {
        this.timeout = timeout;
    }

    @Nullable
    public ChannelFuture getChannelFuture() {
        return this.channelFuture;
    }

    public void setChannelFuture(@NotNull ChannelFuture channelFuture) {
        this.channelFuture = channelFuture;
    }

    public void flushWrite() {
        if (this.channelFuture == null) {
            return;
        }
        try {
            this.channelFuture.sync();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            logger.warn("flushWrite got interrupted.", (Throwable)ie);
        }
    }

    public void release() {
        if (this.timeout != null) {
            this.timeout.cancel();
        }
        this.request.release();
    }

    public boolean isUsedPeer(SocketAddress address) {
        return this.usedPeers.contains(address);
    }

    public void setUsedPeer(SocketAddress address) {
        this.usedPeers.add(address);
    }

    @Nullable
    public ErrorResponse getLastError() {
        return this.lastError;
    }

    public void setLastError(@NotNull ErrorResponse lastError) {
        this.lastError = lastError;
    }

    public void setLastError(ErrorType errorType, Throwable throwable) {
        this.setLastError(new ErrorResponse(this.request.getId(), errorType, throwable));
    }

    public void setLastError(ErrorType errorType, String message) {
        this.setLastError(new ErrorResponse(this.request.getId(), errorType, message));
    }

    public void setFuture(@NotNull Response response) {
        this.release();
        this.setResponseFuture(this.request.getArgScheme(), response);
    }

    public void setFuture() {
        this.setFuture(Response.build(this.request.getArgScheme(), this.getLastError()));
    }

    public void handleResponse(@NotNull ResponseMessage response) {
        if (!response.isError()) {
            this.setFuture((Response)response);
            return;
        }
        this.setLastError((ErrorResponse)response);
        this.request.reset();
        this.subChannel.sendOutRequest(this);
    }

    protected void setResponseFuture(ArgScheme argScheme, Response response) {
        switch (argScheme) {
            case RAW: {
                this.future.set((RawResponse)response);
                break;
            }
            case JSON: {
                this.future.set((JsonResponse)response);
                break;
            }
            case THRIFT: {
                this.future.set((ThriftResponse)response);
                break;
            }
            default: {
                logger.error("unsupported arg scheme: {}", (Object)argScheme);
                this.future.set((RawResponse)response);
            }
        }
    }

    protected boolean shouldRetryOnError() {
        if (this.lastError == null) {
            return false;
        }
        String flags = this.request.getRetryFlags();
        if (flags.contains("n")) {
            return false;
        }
        ErrorType errorType = this.lastError.getErrorType();
        switch (errorType) {
            case BadRequest: 
            case Cancelled: 
            case Unhealthy: {
                return false;
            }
            case Busy: 
            case Declined: {
                return true;
            }
            case Timeout: {
                return flags.contains("t");
            }
            case NetworkError: 
            case FatalProtocolError: 
            case UnexpectedError: {
                return flags.contains("c");
            }
        }
        return false;
    }
}

