/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.handlers;

import com.uber.tchannel.api.errors.TChannelProtocol;
import com.uber.tchannel.codecs.MessageCodec;
import com.uber.tchannel.errors.ErrorType;
import com.uber.tchannel.frames.CallFrame;
import com.uber.tchannel.frames.CallRequestFrame;
import com.uber.tchannel.frames.CallResponseFrame;
import com.uber.tchannel.frames.ErrorFrame;
import com.uber.tchannel.frames.Frame;
import com.uber.tchannel.frames.FrameType;
import com.uber.tchannel.headers.ArgScheme;
import com.uber.tchannel.messages.TChannelMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDefragmenter
extends MessageToMessageDecoder<ByteBuf> {
    private static final Logger logger = LoggerFactory.getLogger(MessageDefragmenter.class);
    private final Map<Long, List<CallFrame>> callFrames = new ConcurrentHashMap<Long, List<CallFrame>>();

    public Map<Long, List<CallFrame>> getCallFrames() {
        return this.callFrames;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        Frame frame = MessageCodec.decode(MessageCodec.decode(buf));
        TChannelMessage msg = null;
        switch (frame.getType()) {
            case CallRequest: 
            case CallResponse: {
                msg = this.decodeCallFrame(ctx, (CallFrame)frame);
                break;
            }
            case CallRequestContinue: 
            case CallResponseContinue: {
                msg = this.decodeCallContinueFrame((CallFrame)frame);
                break;
            }
            case Error: {
                msg = MessageCodec.decodeErrorResponse((ErrorFrame)frame);
                break;
            }
        }
        if (msg != null) {
            out.add(msg);
        }
    }

    private static boolean hasMore(@Nullable Frame frame) {
        return frame instanceof CallFrame && ((CallFrame)frame).moreFragmentsFollow();
    }

    private TChannelMessage decodeCallFrame(ChannelHandlerContext ctx, CallFrame frame) {
        ArgScheme scheme = frame.getType() == FrameType.CallRequest ? ArgScheme.toScheme(((CallRequestFrame)frame).getHeaders().get("as")) : ArgScheme.toScheme(((CallResponseFrame)frame).getHeaders().get("as"));
        if (!ArgScheme.isSupported(scheme)) {
            if (frame.getType() == FrameType.CallRequest) {
                ErrorFrame.sendError(ErrorType.BadRequest, "Arg Scheme not specified or unsupported", frame.getId(), ctx);
            } else {
                logger.error("Arg Scheme not specified or unsupported: {}", (Object)scheme);
            }
            return null;
        }
        ArrayList<CallFrame> frames = new ArrayList<CallFrame>();
        frames.add(frame);
        frame.retain();
        if (!MessageDefragmenter.hasMore(frame)) {
            return MessageCodec.decodeCallFrames(frames);
        }
        this.callFrames.put(frame.getId(), frames);
        return null;
    }

    private TChannelMessage decodeCallContinueFrame(CallFrame frame) throws TChannelProtocol {
        List<CallFrame> frames = this.callFrames.get(frame.getId());
        if (frames == null) {
            throw new TChannelProtocol("Call continue frame recieved before call frame");
        }
        frames.add(frame);
        frame.retain();
        if (!MessageDefragmenter.hasMore(frame)) {
            this.callFrames.remove(frame.getId());
            return MessageCodec.decodeCallFrames(frames);
        }
        return null;
    }
}

