/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.frames;

import com.uber.tchannel.codecs.CodecUtils;
import com.uber.tchannel.codecs.TFrame;
import com.uber.tchannel.frames.FrameType;
import com.uber.tchannel.frames.InitFrame;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.Map;

public final class InitRequestFrame
extends InitFrame {
    private int version;
    private Map<String, String> headers;

    public InitRequestFrame(long id, int version, Map<String, String> headers) {
        this.id = id;
        this.version = version;
        this.headers = headers;
    }

    protected InitRequestFrame(long id) {
        this.id = id;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public FrameType getType() {
        return FrameType.InitRequest;
    }

    @Override
    public String getHostPort() {
        return this.headers.get("host_port");
    }

    public void setHostPort(String hostPort) {
        this.headers.put("host_port", hostPort);
    }

    @Override
    public String getProcessName() {
        return this.headers.get("process_name");
    }

    public void setProcessName(String processName) {
        this.headers.put("process_name", processName);
    }

    public String toString() {
        return String.format("<%s id=%d version=%d headers=%s>", this.getClass().getSimpleName(), this.id, this.version, this.headers);
    }

    @Override
    public ByteBuf encodeHeader(ByteBufAllocator allocator) {
        ByteBuf buffer = allocator.buffer(256);
        buffer.writeShort(this.getVersion());
        CodecUtils.encodeHeaders(this.getHeaders(), buffer);
        return buffer;
    }

    @Override
    public void decode(TFrame tFrame) {
        this.version = tFrame.payload.readUnsignedShort();
        this.headers = CodecUtils.decodeHeaders(tFrame.payload);
    }
}

