/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.frames;

public enum FrameType {
    InitRequest(1),
    InitResponse(2),
    CallRequest(3),
    CallResponse(4),
    CallRequestContinue(19),
    CallResponseContinue(20),
    Cancel(-64),
    Claim(-63),
    PingRequest(-48),
    PingResponse(-47),
    Error(-1);

    private final byte type;

    private FrameType(byte type) {
        this.type = type;
    }

    public static FrameType fromByte(byte value) {
        switch (value) {
            case 1: {
                return InitRequest;
            }
            case 2: {
                return InitResponse;
            }
            case 3: {
                return CallRequest;
            }
            case 4: {
                return CallResponse;
            }
            case 19: {
                return CallRequestContinue;
            }
            case 20: {
                return CallResponseContinue;
            }
            case -64: {
                return Cancel;
            }
            case -63: {
                return Claim;
            }
            case -48: {
                return PingRequest;
            }
            case -47: {
                return PingResponse;
            }
            case -1: {
                return Error;
            }
        }
        return null;
    }

    public byte byteValue() {
        return this.type;
    }
}

