/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.frames;

import com.uber.tchannel.api.errors.TChannelCodec;
import com.uber.tchannel.api.errors.TChannelError;
import com.uber.tchannel.api.errors.TChannelProtocol;
import com.uber.tchannel.codecs.TFrame;
import com.uber.tchannel.frames.CallRequestContinueFrame;
import com.uber.tchannel.frames.CallRequestFrame;
import com.uber.tchannel.frames.CallResponseContinueFrame;
import com.uber.tchannel.frames.CallResponseFrame;
import com.uber.tchannel.frames.CancelFrame;
import com.uber.tchannel.frames.ClaimFrame;
import com.uber.tchannel.frames.ErrorFrame;
import com.uber.tchannel.frames.FrameType;
import com.uber.tchannel.frames.InitRequestFrame;
import com.uber.tchannel.frames.InitResponseFrame;
import com.uber.tchannel.frames.PingRequestFrame;
import com.uber.tchannel.frames.PingResponseFrame;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;

public abstract class Frame {
    protected long id = -1L;

    public final long getId() {
        return this.id;
    }

    public abstract FrameType getType();

    public abstract ByteBuf encodeHeader(ByteBufAllocator var1);

    public abstract void decode(TFrame var1);

    public static Frame create(TFrame tFrame) throws TChannelError {
        Frame frame;
        FrameType type = FrameType.fromByte(tFrame.type);
        if (type == null) {
            throw new TChannelProtocol("Cannot read the frame type");
        }
        switch (type) {
            case CallRequest: {
                frame = new CallRequestFrame(tFrame.id);
                break;
            }
            case CallRequestContinue: {
                frame = new CallRequestContinueFrame(tFrame.id);
                break;
            }
            case CallResponse: {
                frame = new CallResponseFrame(tFrame.id);
                break;
            }
            case CallResponseContinue: {
                frame = new CallResponseContinueFrame(tFrame.id);
                break;
            }
            case Cancel: {
                frame = new CancelFrame(tFrame.id);
                break;
            }
            case Claim: {
                frame = new ClaimFrame(tFrame.id);
                break;
            }
            case Error: {
                frame = new ErrorFrame(tFrame.id);
                break;
            }
            case InitRequest: {
                frame = new InitRequestFrame(tFrame.id);
                break;
            }
            case InitResponse: {
                frame = new InitResponseFrame(tFrame.id);
                break;
            }
            case PingRequest: {
                frame = new PingRequestFrame(tFrame.id);
                break;
            }
            case PingResponse: {
                frame = new PingResponseFrame(tFrame.id);
                break;
            }
            default: {
                throw new TChannelCodec(String.format("Unknown FrameType: %s", new Object[]{type}));
            }
        }
        return frame;
    }
}

