/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.frames;

import com.uber.tchannel.codecs.CodecUtils;
import com.uber.tchannel.codecs.MessageCodec;
import com.uber.tchannel.codecs.TFrame;
import com.uber.tchannel.errors.ErrorType;
import com.uber.tchannel.frames.Frame;
import com.uber.tchannel.frames.FrameType;
import com.uber.tchannel.messages.Request;
import com.uber.tchannel.tracing.Trace;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;

public final class ErrorFrame
extends Frame {
    private ErrorType errorType;
    private Trace tracing;
    private String message;

    public ErrorFrame(long id, ErrorType errorType, Trace tracing, String message) {
        this.id = id;
        this.errorType = errorType;
        this.tracing = tracing;
        this.message = message;
    }

    protected ErrorFrame(long id) {
        this.id = id;
    }

    public ErrorFrame(long id, ErrorType errorType, String message) {
        this.id = id;
        this.errorType = errorType;
        this.tracing = new Trace(0L, 0L, 0L, 0);
        this.message = message;
    }

    @Override
    public FrameType getType() {
        return FrameType.Error;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public Trace getTracing() {
        return this.tracing;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return String.format("<%s id=%d message=%s>", this.getClass().getSimpleName(), this.getId(), this.message);
    }

    @Override
    public ByteBuf encodeHeader(ByteBufAllocator allocator) {
        ByteBuf buffer = allocator.buffer(28);
        buffer.writeByte((int)this.getErrorType().byteValue());
        CodecUtils.encodeTrace(this.getTracing(), buffer);
        CodecUtils.encodeString(this.getMessage(), buffer);
        return buffer;
    }

    @Override
    public void decode(TFrame tFrame) {
        this.errorType = ErrorType.fromByte(tFrame.payload.readByte());
        this.tracing = CodecUtils.decodeTrace(tFrame.payload);
        this.message = CodecUtils.decodeString(tFrame.payload);
    }

    public static ErrorFrame sendError(ErrorType type, String message, Request request, ChannelHandlerContext ctx) {
        ErrorFrame errorFrame = new ErrorFrame(request.getId(), type, new Trace(0L, 0L, 0L, 0), message);
        MessageCodec.write(ctx, errorFrame);
        request.release();
        return errorFrame;
    }

    public static ErrorFrame sendError(ErrorType type, String message, long id, ChannelHandlerContext ctx) {
        ErrorFrame errorFrame = new ErrorFrame(id, type, new Trace(0L, 0L, 0L, 0), message);
        MessageCodec.write(ctx, errorFrame);
        return errorFrame;
    }
}

