/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.frames;

import com.uber.tchannel.codecs.CodecUtils;
import com.uber.tchannel.codecs.TFrame;
import com.uber.tchannel.frames.Frame;
import com.uber.tchannel.frames.FrameType;
import com.uber.tchannel.tracing.Trace;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;

public final class ClaimFrame
extends Frame {
    private long ttl;
    private Trace tracing;

    public ClaimFrame(long id, long ttl, Trace tracing) {
        this.id = id;
        this.ttl = ttl;
        this.tracing = tracing;
    }

    public ClaimFrame(long id) {
        this.id = id;
    }

    @Override
    public FrameType getType() {
        return FrameType.Claim;
    }

    public long getTTL() {
        return this.ttl;
    }

    public Trace getTracing() {
        return this.tracing;
    }

    @Override
    public ByteBuf encodeHeader(ByteBufAllocator allocator) {
        ByteBuf buffer = allocator.buffer(29);
        buffer.writeInt((int)this.getTTL());
        CodecUtils.encodeTrace(this.getTracing(), buffer);
        return buffer;
    }

    @Override
    public void decode(TFrame tFrame) {
        this.ttl = tFrame.payload.readUnsignedInt();
        this.tracing = CodecUtils.decodeTrace(tFrame.payload);
        tFrame.release();
    }
}

