/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.frames;

import com.uber.tchannel.codecs.CodecUtils;
import com.uber.tchannel.codecs.TFrame;
import com.uber.tchannel.frames.Frame;
import com.uber.tchannel.frames.FrameType;
import com.uber.tchannel.tracing.Trace;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;

public final class CancelFrame
extends Frame {
    private long ttl;
    private Trace tracing;
    private String why;

    public CancelFrame(long id, long ttl, Trace tracing, String why) {
        this.id = id;
        this.ttl = ttl;
        this.tracing = tracing;
        this.why = why;
    }

    protected CancelFrame(long id) {
        this.id = id;
    }

    public long getTTL() {
        return this.ttl;
    }

    public Trace getTracing() {
        return this.tracing;
    }

    @Override
    public FrameType getType() {
        return FrameType.Cancel;
    }

    @Override
    public ByteBuf encodeHeader(ByteBufAllocator allocator) {
        ByteBuf buffer = allocator.buffer(31);
        buffer.writeInt((int)this.getTTL());
        CodecUtils.encodeTrace(this.getTracing(), buffer);
        CodecUtils.encodeString(this.getWhy(), buffer);
        return buffer;
    }

    @Override
    public void decode(TFrame tFrame) {
        this.ttl = tFrame.payload.readUnsignedInt();
        this.tracing = CodecUtils.decodeTrace(tFrame.payload);
        this.why = CodecUtils.decodeString(tFrame.payload);
        tFrame.release();
    }

    public String getWhy() {
        return this.why;
    }
}

