/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.frames;

import com.uber.tchannel.checksum.ChecksumType;
import com.uber.tchannel.codecs.CodecUtils;
import com.uber.tchannel.codecs.TFrame;
import com.uber.tchannel.frames.CallFrame;
import com.uber.tchannel.frames.CallRequestContinueFrame;
import com.uber.tchannel.frames.FrameType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;

public final class CallResponseContinueFrame
extends CallFrame {
    public CallResponseContinueFrame(long id, byte flags, ChecksumType checksumType, int checksum, ByteBuf payload) {
        this.id = id;
        this.flags = flags;
        this.checksumType = checksumType;
        this.checksum = checksum;
        this.payload = payload;
    }

    public CallResponseContinueFrame(long id, ChecksumType checksumType, int checksum) {
        this(id, 0, checksumType, checksum, null);
    }

    protected CallResponseContinueFrame(long id) {
        this(id, 0, null, 0, null);
    }

    @Override
    public FrameType getType() {
        return FrameType.CallResponseContinue;
    }

    @Override
    public ByteBuf encodeHeader(ByteBufAllocator allocator) {
        ByteBuf buffer = allocator.buffer(2, 6);
        buffer.writeByte((int)this.getFlags());
        buffer.writeByte((int)this.getChecksumType().byteValue());
        CodecUtils.encodeChecksum(this.getChecksum(), this.getChecksumType(), buffer);
        return buffer;
    }

    @Override
    public void decode(TFrame tFrame) {
        this.flags = tFrame.payload.readByte();
        this.checksumType = ChecksumType.fromByte(tFrame.payload.readByte());
        this.checksum = CodecUtils.decodeChecksum(this.checksumType, tFrame.payload);
        int payloadSize = tFrame.size - tFrame.payload.readerIndex();
        this.payload = tFrame.payload.readSlice(payloadSize);
    }

    public ByteBufHolder replace(ByteBuf payload) {
        return new CallRequestContinueFrame(this.id, this.flags, this.checksumType, this.checksum, payload);
    }
}

