/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.frames;

import com.uber.tchannel.checksum.ChecksumType;
import com.uber.tchannel.codecs.CodecUtils;
import com.uber.tchannel.codecs.TFrame;
import com.uber.tchannel.frames.CallFrame;
import com.uber.tchannel.frames.FrameType;
import com.uber.tchannel.headers.ArgScheme;
import com.uber.tchannel.tracing.Trace;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import java.util.Map;

public class CallRequestFrame
extends CallFrame {
    private long ttl;
    private Trace tracing;
    private String service;
    private Map<String, String> headers;

    public CallRequestFrame(long id, byte flags, long ttl, Trace tracing, String service, Map<String, String> headers, ChecksumType checksumType, int checksum, ByteBuf payload) {
        this.id = id;
        this.flags = flags;
        this.ttl = ttl;
        this.tracing = tracing;
        this.service = service;
        this.headers = headers;
        this.checksumType = checksumType;
        this.checksum = checksum;
        this.payload = payload;
    }

    public CallRequestFrame(long id, long ttl, Trace tracing, String service, Map<String, String> headers, ChecksumType checksumType, int checksum) {
        this(id, 0, ttl, tracing, service, headers, checksumType, checksum, null);
    }

    protected CallRequestFrame(long id) {
        this(id, 0, 0L, null, null, null, null, 0, null);
    }

    @Override
    public FrameType getType() {
        return FrameType.CallRequest;
    }

    public long getTTL() {
        return this.ttl;
    }

    public Trace getTracing() {
        return this.tracing;
    }

    public String getService() {
        return this.service;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public ArgScheme getArgScheme() {
        return ArgScheme.toScheme(this.headers.get("as"));
    }

    @Override
    public ByteBuf encodeHeader(ByteBufAllocator allocator) {
        ByteBuf buffer = allocator.buffer(1024);
        buffer.writeByte((int)this.getFlags());
        buffer.writeInt((int)this.getTTL());
        CodecUtils.encodeTrace(this.getTracing(), buffer);
        CodecUtils.encodeSmallString(this.getService(), buffer);
        CodecUtils.encodeSmallHeaders(this.getHeaders(), buffer);
        buffer.writeByte((int)this.getChecksumType().byteValue());
        CodecUtils.encodeChecksum(this.getChecksum(), this.getChecksumType(), buffer);
        return buffer;
    }

    @Override
    public void decode(TFrame tFrame) {
        this.flags = tFrame.payload.readByte();
        this.ttl = tFrame.payload.readUnsignedInt();
        this.tracing = CodecUtils.decodeTrace(tFrame.payload);
        this.service = CodecUtils.decodeSmallString(tFrame.payload);
        this.headers = CodecUtils.decodeSmallHeaders(tFrame.payload);
        this.checksumType = ChecksumType.fromByte(tFrame.payload.readByte());
        this.checksum = CodecUtils.decodeChecksum(this.checksumType, tFrame.payload);
        int payloadSize = tFrame.size - tFrame.payload.readerIndex();
        this.payload = tFrame.payload.readSlice(payloadSize);
    }

    public ByteBufHolder replace(ByteBuf payload) {
        return new CallRequestFrame(this.id, this.flags, this.ttl, this.tracing, this.service, this.headers, this.checksumType, this.checksum, payload);
    }
}

