/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.errors;

public enum ErrorType {
    Invalid(0),
    Timeout(1),
    Cancelled(2),
    Busy(3),
    Declined(4),
    UnexpectedError(5),
    BadRequest(6),
    NetworkError(7),
    Unhealthy(8),
    FatalProtocolError(-1);

    private final byte code;

    private ErrorType(byte code) {
        this.code = code;
    }

    public static ErrorType fromByte(byte value) {
        switch (value) {
            case 0: {
                return Invalid;
            }
            case 1: {
                return Timeout;
            }
            case 2: {
                return Cancelled;
            }
            case 3: {
                return Busy;
            }
            case 4: {
                return Declined;
            }
            case 5: {
                return UnexpectedError;
            }
            case 6: {
                return BadRequest;
            }
            case 7: {
                return NetworkError;
            }
            case 8: {
                return Unhealthy;
            }
            case -1: {
                return FatalProtocolError;
            }
        }
        return null;
    }

    public byte byteValue() {
        return this.code;
    }
}

