/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.codecs;

import com.uber.tchannel.codecs.TFrame;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;

public final class TFrameCodec
extends ByteToMessageCodec<TFrame> {
    protected void encode(ChannelHandlerContext ctx, TFrame frame, ByteBuf out) throws Exception {
        out.writeShort(frame.size + 16);
        out.writeByte((int)frame.type);
        out.writeZero(1);
        out.writeInt((int)frame.id);
        out.writeZero(8);
        out.writeBytes(frame.payload);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        msg.retain();
        out.add(TFrameCodec.decode(msg));
    }

    public static ByteBuf encode(ByteBufAllocator allocator, TFrame frame) {
        ByteBuf buffer = allocator.buffer(16, 16);
        buffer.writeShort(frame.size + 16);
        buffer.writeByte((int)frame.type);
        buffer.writeZero(1);
        buffer.writeInt((int)frame.id);
        buffer.writeZero(8);
        if (frame.payload instanceof CompositeByteBuf) {
            CompositeByteBuf cbf = (CompositeByteBuf)frame.payload;
            cbf.addComponent(0, buffer);
            cbf.writerIndex(cbf.writerIndex() + 16);
            return cbf;
        }
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{buffer, frame.payload});
    }

    public static TFrame decode(ByteBuf buffer) {
        int size = buffer.readUnsignedShort() - 16;
        byte type = buffer.readByte();
        buffer.skipBytes(1);
        long id = buffer.readUnsignedInt();
        buffer.skipBytes(8);
        ByteBuf payload = buffer.readSlice(size);
        return new TFrame(size, type, id, payload);
    }
}

