/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.codecs;

import com.uber.tchannel.frames.FrameType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;

public class TFrame
implements ByteBufHolder {
    public static final int MAX_FRAME_LENGTH = 65535;
    public static final int FRAME_HEADER_LENGTH = 16;
    public static final int FRAME_SIZE_LENGTH = 2;
    public static final int MAX_FRAME_PAYLOAD_LENGTH = 65519;
    public static final int LENGTH_FIELD_OFFSET = 0;
    public static final int LENGTH_FIELD_LENGTH = 2;
    public static final int LENGTH_ADJUSTMENT = -2;
    public static final int INITIAL_BYTES_TO_STRIP = 0;
    public static final boolean FAIL_FAST = true;
    public final int size;
    public final byte type;
    public final long id;
    public final ByteBuf payload;

    public TFrame(int size, byte type, long id, ByteBuf payload) {
        this.size = size;
        this.type = type;
        this.id = id;
        this.payload = payload;
    }

    public TFrame(int size, FrameType frameType, long id, ByteBuf payload) {
        this(size, frameType.byteValue(), id, payload);
    }

    public String toString() {
        return String.format("<%s size=%d type=0x%d id=%d payload=%s>", this.getClass().getSimpleName(), this.size, this.type, this.id, this.payload);
    }

    public ByteBuf content() {
        return this.payload;
    }

    public ByteBufHolder copy() {
        return this.replace(this.payload.copy());
    }

    public ByteBufHolder duplicate() {
        return this.replace(this.payload.duplicate());
    }

    public ByteBufHolder retain() {
        this.payload.retain();
        return this;
    }

    public ByteBufHolder retain(int i) {
        this.payload.retain(i);
        return this;
    }

    public ByteBufHolder touch() {
        this.payload.touch();
        return this;
    }

    public ByteBufHolder touch(Object o) {
        this.payload.touch(o);
        return this;
    }

    public int refCnt() {
        return this.payload.refCnt();
    }

    public boolean release() {
        return this.payload.release();
    }

    public boolean release(int i) {
        return this.payload.release(i);
    }

    public ByteBufHolder retainedDuplicate() {
        return this.replace(this.payload.retainedDuplicate());
    }

    public ByteBufHolder replace(ByteBuf payload) {
        return new TFrame(this.size, this.type, this.id, payload);
    }
}

