/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.codecs;

import com.uber.tchannel.api.errors.TChannelError;
import com.uber.tchannel.codecs.CodecUtils;
import com.uber.tchannel.codecs.TFrame;
import com.uber.tchannel.codecs.TFrameCodec;
import com.uber.tchannel.frames.CallFrame;
import com.uber.tchannel.frames.CallRequestFrame;
import com.uber.tchannel.frames.CallResponseFrame;
import com.uber.tchannel.frames.ErrorFrame;
import com.uber.tchannel.frames.Frame;
import com.uber.tchannel.frames.FrameType;
import com.uber.tchannel.headers.ArgScheme;
import com.uber.tchannel.messages.ErrorResponse;
import com.uber.tchannel.messages.Request;
import com.uber.tchannel.messages.Response;
import com.uber.tchannel.messages.TChannelMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class MessageCodec {
    private MessageCodec() {
    }

    public static ChannelFuture write(ChannelHandlerContext ctx, Frame frame) {
        ChannelFuture f = ctx.writeAndFlush((Object)MessageCodec.encode(ctx.alloc(), MessageCodec.encode(ctx.alloc(), frame)));
        f.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        return f;
    }

    public static ByteBuf encode(TFrame tFrame) {
        return TFrameCodec.encode((ByteBufAllocator)PooledByteBufAllocator.DEFAULT, tFrame);
    }

    public static ByteBuf encode(ByteBufAllocator allocator, TFrame tFrame) {
        return TFrameCodec.encode(allocator, tFrame);
    }

    public static TFrame decode(ByteBuf buffer) {
        return TFrameCodec.decode(buffer);
    }

    public static TFrame encode(Frame msg) {
        return MessageCodec.encode((ByteBufAllocator)PooledByteBufAllocator.DEFAULT, msg);
    }

    @NotNull
    public static TFrame encode(ByteBufAllocator allocator, @NotNull Frame msg) {
        ByteBuf buffer = msg instanceof CallFrame ? ((CallFrame)msg).getPayload() : msg.encodeHeader(allocator);
        return new TFrame(buffer.writerIndex(), msg.getType(), msg.getId(), buffer);
    }

    public static Frame decode(TFrame tFrame) throws TChannelError {
        Frame frame = Frame.create(tFrame);
        frame.decode(tFrame);
        return frame;
    }

    public static TChannelMessage decodeCallFrames(List<CallFrame> frames) {
        if (frames.isEmpty()) {
            return null;
        }
        CallFrame first = frames.get(0);
        if (first.getType() == FrameType.CallRequest) {
            return MessageCodec.decodeCallRequest(frames);
        }
        return MessageCodec.decodeCallResponse(frames);
    }

    public static ErrorResponse decodeErrorResponse(ErrorFrame frame) {
        return new ErrorResponse(frame.getId(), frame.getErrorType(), frame.getMessage());
    }

    public static Request decodeCallRequest(List<CallFrame> frames) {
        if (frames.isEmpty()) {
            return null;
        }
        CallRequestFrame first = (CallRequestFrame)frames.get(0);
        ArgScheme scheme = ArgScheme.toScheme(first.getHeaders().get("as"));
        if (!ArgScheme.isSupported(scheme)) {
            return null;
        }
        ArrayList<ByteBuf> args = new ArrayList<ByteBuf>();
        for (CallFrame frame : frames) {
            CodecUtils.readArgs(args, frame.getPayload());
            frame.release();
        }
        if (args.size() != 3) {
            for (ByteBuf arg : args) {
                arg.release();
            }
            throw new UnsupportedOperationException("The arg count is not should be 3 instead of " + args.size());
        }
        return Request.build(scheme, first.getId(), first.getTTL(), first.getService(), first.getHeaders(), (ByteBuf)args.get(0), (ByteBuf)args.get(1), (ByteBuf)args.get(2));
    }

    public static Response decodeCallResponse(List<CallFrame> frames) {
        if (frames.isEmpty()) {
            return null;
        }
        CallResponseFrame first = (CallResponseFrame)frames.get(0);
        ArgScheme scheme = ArgScheme.toScheme(first.getHeaders().get("as"));
        if (!ArgScheme.isSupported(scheme)) {
            return null;
        }
        ArrayList<ByteBuf> args = new ArrayList<ByteBuf>();
        for (CallFrame frame : frames) {
            CodecUtils.readArgs(args, frame.getPayload());
            frame.release();
        }
        if (args.size() != 3) {
            for (ByteBuf arg : args) {
                arg.release();
            }
            throw new UnsupportedOperationException("The arg count is not should be 3 instead of " + args.size());
        }
        ((ByteBuf)args.get(0)).release();
        return Response.build(scheme, first.getId(), first.getResponseCode(), first.getHeaders(), (ByteBuf)args.get(1), (ByteBuf)args.get(2));
    }
}

