/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.codecs;

import com.google.common.collect.Maps;
import com.uber.tchannel.checksum.ChecksumType;
import com.uber.tchannel.tracing.Trace;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CodecUtils {
    private CodecUtils() {
    }

    public static int decodeChecksum(@NotNull ChecksumType checksumType, ByteBuf buffer) {
        switch (checksumType) {
            case Adler32: 
            case FarmhashFingerPrint32: 
            case CRC32C: {
                return buffer.readInt();
            }
        }
        return 0;
    }

    public static void encodeChecksum(int checksum, @NotNull ChecksumType checksumType, ByteBuf buffer) {
        switch (checksumType) {
            case Adler32: 
            case FarmhashFingerPrint32: 
            case CRC32C: {
                buffer.writeInt(checksum);
                break;
            }
        }
    }

    @NotNull
    public static String decodeString(@NotNull ByteBuf buffer) {
        int valueLength = buffer.readUnsignedShort();
        byte[] valueBytes = new byte[valueLength];
        buffer.readBytes(valueBytes);
        return new String(valueBytes, StandardCharsets.UTF_8);
    }

    public static void encodeString(@NotNull String value, @NotNull ByteBuf buffer) {
        byte[] raw = value.getBytes(StandardCharsets.UTF_8);
        buffer.writeShort(raw.length);
        buffer.writeBytes(raw);
    }

    @NotNull
    public static String decodeSmallString(@NotNull ByteBuf buffer) {
        short valueLength = buffer.readUnsignedByte();
        byte[] valueBytes = new byte[valueLength];
        buffer.readBytes(valueBytes);
        return new String(valueBytes, StandardCharsets.UTF_8);
    }

    public static void encodeSmallString(@NotNull String value, @NotNull ByteBuf buffer) {
        byte[] raw = value.getBytes(StandardCharsets.UTF_8);
        buffer.writeByte(raw.length);
        buffer.writeBytes(raw);
    }

    @NotNull
    public static Map<String, String> decodeHeaders(@NotNull ByteBuf buffer) {
        int numHeaders = buffer.readUnsignedShort();
        HashMap headers = Maps.newHashMapWithExpectedSize((int)numHeaders);
        for (int i = 0; i < numHeaders; ++i) {
            String key = CodecUtils.decodeString(buffer);
            String value = CodecUtils.decodeString(buffer);
            headers.put(key, value);
        }
        return headers;
    }

    public static void encodeHeaders(@NotNull Map<String, String> headers, @NotNull ByteBuf buffer) {
        buffer.writeShort(headers.size());
        for (Map.Entry<String, String> header : headers.entrySet()) {
            CodecUtils.encodeString(header.getKey(), buffer);
            CodecUtils.encodeString(header.getValue(), buffer);
        }
    }

    @NotNull
    public static Map<String, String> decodeSmallHeaders(@NotNull ByteBuf buffer) {
        int numHeaders = buffer.readUnsignedByte();
        HashMap headers = Maps.newHashMapWithExpectedSize((int)numHeaders);
        for (int i = 0; i < numHeaders; ++i) {
            String key = CodecUtils.decodeSmallString(buffer);
            String value = CodecUtils.decodeSmallString(buffer);
            headers.put(key, value);
        }
        return headers;
    }

    public static void encodeSmallHeaders(@NotNull Map<String, String> headers, @NotNull ByteBuf buffer) {
        buffer.writeByte(headers.size());
        for (Map.Entry<String, String> header : headers.entrySet()) {
            CodecUtils.encodeSmallString(header.getKey(), buffer);
            CodecUtils.encodeSmallString(header.getValue(), buffer);
        }
    }

    @NotNull
    public static Trace decodeTrace(@NotNull ByteBuf buffer) {
        long spanId = buffer.readLong();
        long parentId = buffer.readLong();
        long traceId = buffer.readLong();
        byte traceFlags = buffer.readByte();
        return new Trace(spanId, parentId, traceId, traceFlags);
    }

    public static void encodeTrace(@NotNull Trace trace, @NotNull ByteBuf buffer) {
        buffer.writeLong(trace.spanId).writeLong(trace.parentId).writeLong(trace.traceId).writeByte((int)trace.traceFlags);
    }

    public static int writeArg(@NotNull ByteBufAllocator allocator, @NotNull ByteBuf arg, int writableBytes, @NotNull List<ByteBuf> bufs) {
        if (writableBytes <= 2) {
            throw new UnsupportedOperationException("writableBytes must be larger than 2");
        }
        int readableBytes = arg.readableBytes();
        ByteBuf sizeBuf = allocator.buffer(2);
        bufs.add(sizeBuf);
        int headerSize = 2;
        int chunkLength = Math.min(readableBytes + headerSize, writableBytes);
        sizeBuf.writeShort(chunkLength - headerSize);
        if (readableBytes == 0) {
            return 2;
        }
        bufs.add(arg.readSlice(chunkLength - headerSize).retain());
        return chunkLength;
    }

    @NotNull
    public static ByteBuf writeArgs(@NotNull ByteBufAllocator allocator, @NotNull ByteBuf header, @NotNull List<ByteBuf> args) {
        ByteBuf arg;
        int len;
        int writableBytes = 65519 - header.readableBytes();
        ArrayList<ByteBuf> bufs = new ArrayList<ByteBuf>(7);
        bufs.add(header);
        while (!args.isEmpty() && (writableBytes -= (len = CodecUtils.writeArg(allocator, arg = args.get(0), writableBytes, bufs))) > 2) {
            if (arg.readableBytes() != 0) continue;
            args.remove(0);
        }
        CompositeByteBuf comp = allocator.compositeBuffer();
        comp.addComponents(bufs);
        comp.writerIndex(65519 - writableBytes);
        return comp;
    }

    @NotNull
    public static ByteBuf writeArgCopy(ByteBufAllocator allocator, @NotNull ByteBuf payload, @NotNull ByteBuf arg, int writableBytes) {
        if (writableBytes <= 2) {
            throw new UnsupportedOperationException("writableBytes must be larger than 2");
        }
        int readableBytes = arg.readableBytes();
        int headerSize = 2;
        int chunkLength = Math.min(readableBytes + headerSize, writableBytes);
        payload.writeShort(chunkLength - headerSize);
        if (readableBytes == 0) {
            return payload;
        }
        return payload.writeBytes(arg, chunkLength - headerSize);
    }

    @NotNull
    public static ByteBuf writeArgsCopy(@NotNull ByteBufAllocator allocator, @NotNull ByteBuf header, @NotNull List<ByteBuf> args) {
        ByteBuf payload = allocator.buffer(header.readableBytes(), 65519);
        payload.writeBytes(header);
        header.release();
        int writableBytes = 65519 - payload.readableBytes();
        while (!args.isEmpty()) {
            ByteBuf arg = args.get(0);
            CodecUtils.writeArgCopy(allocator, payload, arg, writableBytes);
            writableBytes = 65519 - payload.readableBytes();
            if (writableBytes <= 2) break;
            if (arg.readableBytes() != 0) continue;
            args.remove(0);
        }
        return payload;
    }

    @NotNull
    public static ByteBuf compose(@NotNull ByteBuf first, @NotNull ByteBuf second) {
        if (first == Unpooled.EMPTY_BUFFER) {
            return second;
        }
        if (second == Unpooled.EMPTY_BUFFER) {
            return first;
        }
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{first, second});
    }

    @Nullable
    public static ByteBuf readArg(@NotNull ByteBuf buffer) {
        if (buffer.readableBytes() < 2) {
            return null;
        }
        int len = buffer.readUnsignedShort();
        if (len > buffer.readableBytes()) {
            throw new UnsupportedOperationException("wrong read index for args");
        }
        if (len == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf arg = buffer.readSlice(len);
        arg.retain();
        return arg;
    }

    public static void readArgs(@NotNull List<ByteBuf> args, @NotNull ByteBuf buffer) {
        if (args.isEmpty()) {
            args.add(Unpooled.EMPTY_BUFFER);
        }
        boolean first = true;
        ByteBuf arg;
        while ((arg = CodecUtils.readArg(buffer)) != null) {
            if (first) {
                first = false;
                ByteBuf prev = args.get(args.size() - 1);
                args.set(args.size() - 1, CodecUtils.compose(prev, arg));
                continue;
            }
            args.add(arg);
        }
        return;
    }
}

