/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.checksum;

import com.uber.tchannel.frames.CallFrame;
import io.netty.buffer.ByteBuf;
import java.util.zip.Adler32;

public final class Checksums {
    private Checksums() {
    }

    public static boolean verifyChecksum(CallFrame msg) {
        return Checksums.calculateChecksum(msg) == (long)msg.getChecksum();
    }

    public static boolean verifyExistingChecksum(CallFrame msg, long checksum) {
        return (long)msg.getChecksum() == checksum;
    }

    public static long calculateChecksum(CallFrame msg) {
        return Checksums.calculateChecksum(msg, 0L);
    }

    public static long calculateChecksum(CallFrame msg, long digestSeed) {
        ByteBuf payloadCopy = msg.getPayload().slice();
        byte[] payloadBytes = new byte[msg.getPayloadSize()];
        payloadCopy.readBytes(payloadBytes);
        switch (msg.getChecksumType()) {
            case Adler32: {
                Adler32 f = new Adler32();
                f.update((int)digestSeed);
                f.update(payloadBytes);
                return f.getValue();
            }
        }
        return 0L;
    }
}

