/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.channels;

import com.uber.tchannel.api.SubChannel;
import com.uber.tchannel.channels.Connection;
import com.uber.tchannel.channels.ConnectionState;
import com.uber.tchannel.channels.Peer;
import com.uber.tchannel.channels.PeerManager;
import com.uber.tchannel.handlers.OutRequest;
import java.net.SocketAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubPeer {
    private static final double SCORE_UNCONNECTED = 1.0;
    private static final double SCORE_CONNECTED = 2.0;
    private static final double SCORE_IDENTIFIED = 3.0;
    private static final double SCORE_PREFERRED_DIRECTION = 4.0;
    private static final double SCORE_FUZZ = 0.5;
    private final SocketAddress remoteAddress;
    @NotNull
    private final PeerManager peerManager;
    private double score = 0.0;
    @Nullable
    private Connection connection = null;
    private Connection.Direction direction = Connection.Direction.NONE;

    public SubPeer(SocketAddress remoteAddress, @NotNull SubChannel subChannel) {
        this.remoteAddress = remoteAddress;
        this.peerManager = subChannel.getPeerManager();
        this.direction = subChannel.getPreferredDirection();
    }

    @NotNull
    public SubPeer setPreference(Connection.Direction direction) {
        this.direction = direction;
        return this;
    }

    @Nullable
    public Peer getPeer() {
        return this.peerManager.getPeer(this.remoteAddress);
    }

    public boolean updateScore(@NotNull OutRequest<?> outRequest) {
        if (outRequest.isUsedPeer(this.remoteAddress)) {
            this.score = 0.9;
            return false;
        }
        Peer peer = this.getPeer();
        boolean flag = false;
        if (peer == null) {
            this.score = 1.0;
            return flag;
        }
        this.connection = peer.getConnection(ConnectionState.IDENTIFIED, this.direction);
        if (!ConnectionState.isConnected(this.connection)) {
            this.score = 1.0;
        } else if (!this.connection.isIdentified()) {
            this.score = 2.0;
        } else if (this.direction != Connection.Direction.NONE && this.direction != this.connection.direction) {
            this.score = 3.0;
        } else {
            flag = true;
            this.score = 4.0;
        }
        return flag;
    }

    @Nullable
    public Connection getPreferredConnection() {
        return this.connection;
    }

    public double getScore() {
        return this.score;
    }

    @NotNull
    public Connection connectTo() {
        return this.peerManager.connectTo(this.remoteAddress);
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }
}

