/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.channels;

import com.google.common.collect.Maps;
import com.uber.tchannel.channels.Connection;
import com.uber.tchannel.channels.Peer;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerManager {
    private static final Logger logger = LoggerFactory.getLogger(PeerManager.class);
    private final Bootstrap clientBootstrap;
    @NotNull
    private final ConcurrentHashMap<SocketAddress, Peer> peers = new ConcurrentHashMap();
    private final ConcurrentHashMap<ChannelId, SocketAddress> channelTable = new ConcurrentHashMap();
    private final ConcurrentHashMap<ChannelId, Connection> inConnections = new ConcurrentHashMap();
    private String hostPort = "0.0.0.0:0";

    public PeerManager(Bootstrap clientBootstrap) {
        this.clientBootstrap = clientBootstrap;
    }

    public Connection findOrNew(@NotNull SocketAddress address) {
        return this.findOrNewPeer(address).connect(this.clientBootstrap);
    }

    public Peer findOrNewPeer(@NotNull SocketAddress address) {
        Peer peer = this.peers.get(address);
        if (peer == null) {
            this.peers.putIfAbsent(address, new Peer(this, address));
            peer = this.peers.get(address);
        }
        return peer;
    }

    @Nullable
    public Peer getPeer(@NotNull SocketAddress address) {
        return this.peers.get(address);
    }

    @Nullable
    public Peer getPeer(@NotNull Channel channel) {
        return this.peers.get(channel.remoteAddress());
    }

    public Connection connectTo(@NotNull SocketAddress address) {
        return this.findOrNewPeer(address).connect(this.clientBootstrap, Connection.Direction.OUT);
    }

    @Nullable
    public Connection get(@NotNull Channel channel) {
        Peer peer = this.peers.get(channel.remoteAddress());
        return peer == null ? null : peer.getConnection(channel.id());
    }

    public void add(@NotNull ChannelHandlerContext ctx) {
        if (!ctx.pipeline().names().contains("InitRequestHandler")) {
            this.findOrNewPeer(ctx.channel().remoteAddress()).handleActiveOutConnection(ctx);
        }
    }

    @Nullable
    public Connection remove(@NotNull Channel channel) {
        Peer peer = this.peers.get(channel.remoteAddress());
        if (peer != null) {
            return peer.remove(channel);
        }
        SocketAddress address = this.channelTable.remove(channel.id());
        if (address != null && (peer = this.peers.get(address)) != null) {
            return peer.remove(channel);
        }
        return null;
    }

    public void setIdentified(@NotNull Channel channel, @NotNull Map<String, String> headers) {
        Connection conn = this.get(channel);
        if (conn == null) {
            conn = new Connection(null, channel, Connection.Direction.IN);
        }
        conn.setIdentified(headers);
        if (!conn.isEphemeral() && conn.direction == Connection.Direction.IN) {
            SocketAddress address = conn.getRemoteAddressAsSocketAddress();
            this.channelTable.put(channel.id(), address);
            Peer peer = this.findOrNewPeer(address);
            conn.setPeer(peer);
            peer.add(conn);
        }
    }

    public void handleConnectionErrors(@NotNull Channel channel, @NotNull Throwable cause) {
        logger.error("Resetting connection due to the error.", cause);
        Connection conn = this.remove(channel);
        if (conn != null) {
            conn.clean();
        }
    }

    public void close() {
        for (Peer peer : this.peers.values()) {
            peer.close();
        }
        this.peers.clear();
    }

    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public String getHostPort() {
        return this.hostPort;
    }

    @NotNull
    public Map<String, Integer> getStats() {
        int in = 0;
        int out = 0;
        for (Peer peer : this.peers.values()) {
            Map<String, Integer> connStats = peer.getStats();
            in += connStats.get("connections.in").intValue();
            out += connStats.get("connections.out").intValue();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        result.put("connections.in", in);
        result.put("connections.out", out);
        return result;
    }
}

