/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.channels;

import com.google.common.collect.Maps;
import com.uber.tchannel.api.errors.TChannelConnectionFailure;
import com.uber.tchannel.channels.Connection;
import com.uber.tchannel.channels.ConnectionState;
import com.uber.tchannel.channels.PeerManager;
import com.uber.tchannel.codecs.MessageCodec;
import com.uber.tchannel.frames.InitRequestFrame;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Peer {
    @NotNull
    public final ConcurrentHashMap<ChannelId, Connection> connections = new ConcurrentHashMap();
    public final SocketAddress remoteAddress;
    @NotNull
    private final PeerManager manager;

    public Peer(@NotNull PeerManager manager, SocketAddress remoteAddress) {
        this.manager = manager;
        this.remoteAddress = remoteAddress;
    }

    @NotNull
    public Connection add(@NotNull Connection connection) {
        Connection conn = this.connections.putIfAbsent(connection.channel().id(), connection);
        return conn == null ? connection : conn;
    }

    @NotNull
    public Connection add(@NotNull Channel channel, Connection.Direction direction) {
        Connection conn = this.connections.get(channel.id());
        return conn == null ? this.add(new Connection(this, channel, direction)) : conn;
    }

    @NotNull
    public Connection handleActiveOutConnection(@NotNull ChannelHandlerContext ctx) {
        Connection conn = this.add(ctx.channel(), Connection.Direction.OUT);
        InitRequestFrame initRequestFrame = new InitRequestFrame(0L, 2, new HashMap<String, String>());
        initRequestFrame.setHostPort(this.manager.getHostPort());
        initRequestFrame.setProcessName("java-process");
        MessageCodec.write(ctx, initRequestFrame);
        return conn;
    }

    public void remove(@NotNull Connection connection) {
        this.connections.remove(connection.channel().id());
    }

    @Nullable
    public Connection remove(@NotNull Channel channel) {
        return this.connections.remove(channel.id());
    }

    @NotNull
    public Connection connect(Bootstrap bootstrap, Connection.Direction preferredDirection) {
        Connection conn = this.getConnection(ConnectionState.IDENTIFIED, preferredDirection);
        if (conn != null && (preferredDirection == Connection.Direction.IN || conn.satisfy(preferredDirection))) {
            return conn;
        }
        ChannelFuture f = bootstrap.connect(this.remoteAddress);
        Channel channel = f.channel();
        final Connection connection = this.add(channel, Connection.Direction.OUT);
        f.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    connection.setIdentified(new TChannelConnectionFailure(future.cause()));
                }
            }
        });
        return connection;
    }

    @NotNull
    public Connection connect(Bootstrap bootstrap) {
        return this.connect(bootstrap, Connection.Direction.NONE);
    }

    @Nullable
    public Connection getConnection(@Nullable ConnectionState preferredState, Connection.Direction preferredDirection) {
        Connection conn = null;
        for (Connection next : this.connections.values()) {
            if (next.satisfy(preferredState)) {
                conn = next;
                if (preferredDirection != Connection.Direction.NONE && conn.direction != preferredDirection) continue;
                break;
            }
            if (conn != null) continue;
            conn = next;
        }
        return conn;
    }

    @Nullable
    public Connection getConnection(ConnectionState preferredState) {
        return this.getConnection(preferredState, Connection.Direction.NONE);
    }

    @Nullable
    public Connection getConnection(@NotNull ChannelId channelId) {
        return this.connections.get(channelId);
    }

    public void close() {
        for (Connection conn : this.connections.values()) {
            conn.close();
        }
        this.connections.clear();
    }

    @NotNull
    public Map<String, Integer> getStats() {
        int in = 0;
        int out = 0;
        for (Connection conn : this.connections.values()) {
            if (conn.direction == Connection.Direction.OUT) {
                ++out;
                continue;
            }
            ++in;
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        result.put("connections.in", in);
        result.put("connections.out", out);
        return result;
    }
}

