/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.channels;

import com.uber.tchannel.channels.Connection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ConnectionState {
    UNCONNECTED("unconnected"),
    CONNECTED("connected"),
    IDENTIFIED("identified"),
    DESTROYED("destroyed");

    @NotNull
    private final String state;

    private ConnectionState(String state) {
        this.state = state;
    }

    @Nullable
    public static ConnectionState toState(@Nullable String state) {
        if (state == null) {
            return null;
        }
        switch (state) {
            case "unconnected": {
                return UNCONNECTED;
            }
            case "connected": {
                return CONNECTED;
            }
            case "identified": {
                return IDENTIFIED;
            }
            case "destroyed": {
                return DESTROYED;
            }
        }
        return null;
    }

    public static boolean isConnected(ConnectionState state) {
        return state == IDENTIFIED || state == CONNECTED;
    }

    public static boolean isConnected(@Nullable Connection conn) {
        return conn != null && ConnectionState.isConnected(conn.state);
    }

    @NotNull
    public String getState() {
        return this.state;
    }
}

