/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.channels;

import com.uber.tchannel.api.errors.TChannelError;
import com.uber.tchannel.channels.ConnectionState;
import com.uber.tchannel.channels.Peer;
import com.uber.tchannel.handlers.ResponseRouter;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    private static final String EPHEMERAL = "0.0.0.0:0";
    public Direction direction = Direction.NONE;
    public ConnectionState state = ConnectionState.UNCONNECTED;
    private Peer peer;
    @NotNull
    private final Channel channel;
    @Nullable
    private String remoteAddress = null;
    @Nullable
    private TChannelError lastError = null;
    @NotNull
    protected final Object lock;

    public Connection(Peer peer, @NotNull Channel channel, Direction direction) {
        this.peer = peer;
        this.channel = channel;
        this.direction = direction;
        if (channel.isActive() && this.state == ConnectionState.UNCONNECTED) {
            this.state = ConnectionState.CONNECTED;
        }
        this.lock = new Object();
    }

    @NotNull
    public Channel channel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TChannelError lastError() {
        Object object = this.lock;
        synchronized (object) {
            return this.lastError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean satisfy(@Nullable ConnectionState preferredState) {
        Object object = this.lock;
        synchronized (object) {
            ConnectionState connState = this.state;
            if (connState == ConnectionState.DESTROYED) {
                return false;
            }
            if (preferredState == null) {
                return true;
            }
            if (connState == preferredState || connState == ConnectionState.IDENTIFIED) {
                return true;
            }
            return connState == ConnectionState.CONNECTED && preferredState == ConnectionState.UNCONNECTED;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean satisfy(@Nullable Direction preferredDirection) {
        Object object = this.lock;
        synchronized (object) {
            return preferredDirection == null || preferredDirection == Direction.NONE || preferredDirection == this.direction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(ConnectionState state) {
        Object object = this.lock;
        synchronized (object) {
            this.state = state;
            if (state == ConnectionState.IDENTIFIED || state == ConnectionState.UNCONNECTED && this.lastError != null) {
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdentified(@NotNull Map<String, String> headers) {
        Object object = this.lock;
        synchronized (object) {
            String hostPort = headers.get("host_port");
            this.remoteAddress = hostPort == null ? EPHEMERAL : hostPort.trim();
            this.setState(ConnectionState.IDENTIFIED);
        }
    }

    @Deprecated
    public void setIndentified(@NotNull Map<String, String> headers) {
        this.setIdentified(headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setIdentified(TChannelError error) {
        Object object = this.lock;
        synchronized (object) {
            this.remoteAddress = null;
            this.lastError = error;
            this.setState(ConnectionState.UNCONNECTED);
        }
    }

    @Deprecated
    public void setIndentified(TChannelError error) {
        this.setIdentified(error);
    }

    public boolean isIdentified() {
        return this.state == ConnectionState.IDENTIFIED;
    }

    @Deprecated
    public boolean isIndentified() {
        return this.isIdentified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEphemeral() {
        Object object = this.lock;
        synchronized (object) {
            return EPHEMERAL.equals(this.remoteAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getRemoteAddress() {
        Object object = this.lock;
        synchronized (object) {
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SocketAddress getRemoteAddressAsSocketAddress() {
        Object object = this.lock;
        synchronized (object) {
            return Connection.hostPortToSocketAddress(this.remoteAddress);
        }
    }

    @NotNull
    public static String[] splitHostPort(@NotNull String hostPort) {
        String[] strs = hostPort.split(":");
        if (strs.length != 2) {
            strs = new String[]{"0.0.0.0:", "0"};
        }
        return strs;
    }

    @NotNull
    public static SocketAddress hostPortToSocketAddress(@NotNull String hostPort) {
        String[] strs = Connection.splitHostPort(hostPort);
        return new InetSocketAddress(strs[0], Integer.parseInt(strs[1]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForIdentified(long timeout) {
        Object object = this.lock;
        synchronized (object) {
            boolean result;
            try {
                if (this.state != ConnectionState.IDENTIFIED) {
                    this.lastError = null;
                    this.lock.wait(timeout);
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                logger.warn("wait for identified is interrupted.", (Throwable)ex);
            }
            boolean bl = result = this.state == ConnectionState.IDENTIFIED;
            if (!result) {
                this.clean();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            ResponseRouter responseRouter = (ResponseRouter)this.channel.pipeline().get(ResponseRouter.class);
            if (responseRouter != null) {
                responseRouter.clean();
            }
            this.channel.close();
            this.state = ConnectionState.DESTROYED;
        }
    }

    public void clean() {
        this.close();
        this.peer.remove(this);
    }

    public Peer getPeer() {
        return this.peer;
    }

    public void setPeer(Peer peer) {
        this.peer = peer;
    }

    public static enum Direction {
        NONE,
        IN,
        OUT;

    }
}

