/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.channels;

import com.uber.tchannel.channels.PeerManager;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelRegistrar
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ChannelRegistrar.class);
    private final PeerManager peerManager;

    public ChannelRegistrar(PeerManager peerManager) {
        this.peerManager = peerManager;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.peerManager.add(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.peerManager.remove(ctx.channel());
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) throws Exception {
        logger.error("Exception detected, reseting connection.", cause);
        this.peerManager.handleConnectionErrors(ctx.channel(), cause);
    }
}

