/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.api;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.uber.tchannel.api.handlers.TFutureCallback;
import com.uber.tchannel.errors.ErrorType;
import com.uber.tchannel.headers.ArgScheme;
import com.uber.tchannel.messages.Response;
import com.uber.tchannel.tracing.TracingContext;
import io.opentracing.Span;
import java.util.EmptyStackException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TFuture<V extends Response>
extends AbstractFuture<V> {
    private static final Logger logger = LoggerFactory.getLogger(TFuture.class);
    private final AtomicInteger listenerCount = new AtomicInteger(0);
    private final ArgScheme argScheme;
    @Nullable
    private final TracingContext tracingContext;
    private V response = null;

    @NotNull
    public static <T extends Response> TFuture<T> create(ArgScheme argScheme, @Nullable TracingContext tracingContext) {
        return new TFuture(argScheme, tracingContext);
    }

    @Deprecated
    @NotNull
    public static <T extends Response> TFuture<T> create(ArgScheme argScheme) {
        return TFuture.create(argScheme, null);
    }

    private TFuture(ArgScheme argScheme, @Nullable TracingContext tracingContext) {
        this.argScheme = argScheme;
        this.tracingContext = tracingContext;
    }

    public void addCallback(final TFutureCallback<V> callback) {
        Futures.addCallback((ListenableFuture)this, (FutureCallback)new FutureCallback<V>(){

            public void onSuccess(V response) {
                callback.onResponse(response);
            }

            public void onFailure(@NotNull Throwable throwable) {
                callback.onResponse(Response.build(TFuture.this.argScheme, 0L, ErrorType.UnexpectedError, throwable.getMessage()));
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public boolean set(V response) {
        if (this.listenerCount.get() == 0 && !((Response)response).isError()) {
            logger.warn("No handler is set when response is set. Resource leak may occur.", (Throwable)new IllegalStateException());
        }
        this.response = response;
        return super.set(response);
    }

    public boolean setException(Throwable throwable) {
        return super.setException(throwable);
    }

    public void addListener(final Runnable listener, Executor exec) {
        this.listenerCount.incrementAndGet();
        final Span span = this.tracingContext != null && this.tracingContext.hasSpan() ? this.tracingContext.currentSpan() : null;
        super.addListener(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block12: {
                    if (span != null) {
                        TFuture.this.tracingContext.pushSpan(span);
                    }
                    try {
                        listener.run();
                        if (span == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (span != null) {
                            try {
                                Span poppedSpan = TFuture.this.tracingContext.popSpan();
                                if (!span.equals(poppedSpan)) {
                                    logger.error("Corrupted tracing context after running listener {}: expected span {} but got {}", new Object[]{listener, span, poppedSpan});
                                }
                            }
                            catch (EmptyStackException e) {
                                logger.error("Corrupted (empty) tracing context after running listener {}", (Object)listener, (Object)e);
                            }
                        }
                        if (TFuture.this.listenerCount.decrementAndGet() == 0) {
                            TFuture.this.response.release();
                        }
                        throw throwable;
                    }
                    try {
                        Span poppedSpan = TFuture.this.tracingContext.popSpan();
                        if (!span.equals(poppedSpan)) {
                            logger.error("Corrupted tracing context after running listener {}: expected span {} but got {}", new Object[]{listener, span, poppedSpan});
                        }
                    }
                    catch (EmptyStackException e) {
                        logger.error("Corrupted (empty) tracing context after running listener {}", (Object)listener, (Object)e);
                    }
                }
                if (TFuture.this.listenerCount.decrementAndGet() == 0) {
                    TFuture.this.response.release();
                }
            }
        }, exec);
    }

    public V get() throws InterruptedException, ExecutionException {
        this.listenerCount.incrementAndGet();
        return (V)((Response)super.get());
    }

    public V get(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException("Get timeout is unsupported. Use request timeout instead.");
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("Cancel is not supported.");
    }
}

