/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.api;

import com.uber.tchannel.api.SubChannel;
import com.uber.tchannel.api.handlers.RequestHandler;
import com.uber.tchannel.channels.ChannelRegistrar;
import com.uber.tchannel.channels.Connection;
import com.uber.tchannel.channels.PeerManager;
import com.uber.tchannel.codecs.TChannelLengthFieldBasedFrameDecoder;
import com.uber.tchannel.handlers.InitRequestHandler;
import com.uber.tchannel.handlers.InitRequestInitiator;
import com.uber.tchannel.handlers.MessageDefragmenter;
import com.uber.tchannel.handlers.MessageFragmenter;
import com.uber.tchannel.handlers.RequestRouter;
import com.uber.tchannel.handlers.ResponseRouter;
import com.uber.tchannel.messages.Request;
import com.uber.tchannel.tracing.OpenTracingContext;
import com.uber.tchannel.tracing.TracingContext;
import com.uber.tchannel.utils.TChannelUtilities;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.HashedWheelTimer;
import io.netty.util.concurrent.Future;
import io.opentracing.Tracer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TChannel {
    private static final Logger logger = LoggerFactory.getLogger(TChannel.class);
    private final HashedWheelTimer timer;
    @NotNull
    private final String service;
    private final ServerBootstrap serverBootstrap;
    @NotNull
    private final PeerManager peerManager;
    @NotNull
    private final EventLoopGroup bossGroup;
    @NotNull
    private final EventLoopGroup childGroup;
    private final InetAddress host;
    private final int port;
    private String listeningHost = "0.0.0.0";
    private int listeningPort;
    private final long initTimeout;
    private final int resetOnTimeoutLimit;
    private final int clientMaxPendingRequests;
    private final Tracer tracer;
    private final TracingContext tracingContext;
    @NotNull
    private final Map<String, SubChannel> subChannels = new HashMap<String, SubChannel>();
    @Nullable
    private RequestHandler defaultUserHandler;
    @Nullable
    private SimpleChannelInboundHandler<Request> customRequestRouter;

    private TChannel(@NotNull Builder builder) {
        this.service = builder.service;
        this.serverBootstrap = builder.serverBootstrap(this);
        this.bossGroup = builder.bossGroup;
        this.childGroup = builder.childGroup;
        this.host = builder.host;
        this.port = builder.port;
        this.initTimeout = builder.initTimeout;
        this.resetOnTimeoutLimit = builder.resetOnTimeoutLimit;
        this.peerManager = new PeerManager(builder.bootstrap(this));
        this.timer = builder.timer;
        this.clientMaxPendingRequests = builder.clientMaxPendingRequests;
        this.tracer = builder.tracer;
        this.tracingContext = builder.tracingContext == null ? (this.tracer == null ? new TracingContext.Default() : new OpenTracingContext(this.tracer.scopeManager())) : builder.tracingContext;
    }

    public String getListeningHost() {
        return this.listeningHost;
    }

    public int getListeningPort() {
        return this.listeningPort;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @NotNull
    public String getServiceName() {
        return this.service;
    }

    @NotNull
    public PeerManager getPeerManager() {
        return this.peerManager;
    }

    public int getResetOnTimeoutLimit() {
        return this.resetOnTimeoutLimit;
    }

    public long getInitTimeout() {
        return this.initTimeout;
    }

    public boolean isListening() {
        return !"0.0.0.0".equals(this.listeningHost);
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public TracingContext getTracingContext() {
        return this.tracingContext;
    }

    @NotNull
    public ChannelFuture listen() throws InterruptedException {
        ChannelFuture f = this.serverBootstrap.bind(this.host, this.port).sync();
        InetSocketAddress localAddress = (InetSocketAddress)f.channel().localAddress();
        this.listeningPort = localAddress.getPort();
        this.listeningHost = localAddress.getAddress().getHostAddress();
        this.peerManager.setHostPort(String.format("%s:%d", this.listeningHost, this.listeningPort));
        return f;
    }

    public void setDefaultUserHandler(@Nullable RequestHandler requestHandler) {
        this.defaultUserHandler = requestHandler;
    }

    @Nullable
    public SubChannel getSubChannel(String service) {
        return this.subChannels.get(service);
    }

    @NotNull
    public SubChannel makeSubChannel(String service, Connection.Direction preferredDirection) {
        SubChannel subChannel;
        if (this.isListening()) {
            logger.warn("makeSubChannel should be called before listen - service: {}", (Object)service);
        }
        if ((subChannel = this.getSubChannel(service)) == null) {
            subChannel = new SubChannel(service, this, preferredDirection);
            this.subChannels.put(service, subChannel);
        }
        return subChannel;
    }

    @NotNull
    public SubChannel makeSubChannel(String service) {
        return this.makeSubChannel(service, Connection.Direction.NONE);
    }

    public void shutdown(boolean sync) {
        this.timer.stop();
        this.peerManager.close();
        Future bg = this.bossGroup.shutdownGracefully();
        Future cg = this.childGroup.shutdownGracefully();
        try {
            if (sync) {
                bg.get();
                cg.get();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            logger.warn("shutdown interrupted.", (Throwable)ie);
        }
        catch (ExecutionException ee) {
            logger.warn("shutdown runs into an ExecutionException.", (Throwable)ee);
        }
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public int getClientMaxPendingRequests() {
        return this.clientMaxPendingRequests;
    }

    @Nullable
    public RequestHandler getDefaultUserHandler() {
        return this.defaultUserHandler;
    }

    @Nullable
    public SimpleChannelInboundHandler<Request> getCustomRequestRouter() {
        return this.customRequestRouter;
    }

    public void setCustomRequestRouter(@Nullable SimpleChannelInboundHandler<Request> customRequestRouter) {
        this.customRequestRouter = customRequestRouter;
    }

    public static class Builder {
        @NotNull
        private final HashedWheelTimer timer;
        private static ExecutorService defaultExecutorService = null;
        @NotNull
        private EventLoopGroup bossGroup;
        @NotNull
        private EventLoopGroup childGroup;
        private static final boolean useEpoll = Epoll.isAvailable();
        @NotNull
        private final String service;
        private InetAddress host;
        private int port = 0;
        private long initTimeout = -1L;
        private int resetOnTimeoutLimit = Integer.MAX_VALUE;
        private int clientMaxPendingRequests = 100000;
        private static final int WRITE_BUFFER_LOW_WATER_MARK = 8192;
        private static final int WRITE_BUFFER_HIGH_WATER_MARK = 32768;
        private Tracer tracer;
        private TracingContext tracingContext;
        private ExecutorService executorService = null;

        public Builder(@NotNull String service) {
            if (service == null) {
                throw new NullPointerException("`service` cannot be null");
            }
            this.service = service;
            this.host = TChannelUtilities.getCurrentIp();
            if (this.host == null) {
                logger.error("failed to get current IP");
            }
            this.timer = new HashedWheelTimer(10L, TimeUnit.MILLISECONDS);
            this.bossGroup = useEpoll ? new EpollEventLoopGroup(1) : new NioEventLoopGroup(1);
            this.childGroup = useEpoll ? new EpollEventLoopGroup() : new NioEventLoopGroup();
        }

        @NotNull
        private static synchronized ExecutorService defaultExecutorService() {
            if (defaultExecutorService == null) {
                defaultExecutorService = new ForkJoinPool();
            }
            return defaultExecutorService;
        }

        @NotNull
        private ExecutorService getExecutorService() {
            return this.executorService == null ? Builder.defaultExecutorService() : this.executorService;
        }

        @NotNull
        public Builder setExecutorService(@Nullable ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @NotNull
        public Builder setClientMaxPendingRequests(int clientMaxPendingRequests) {
            this.clientMaxPendingRequests = clientMaxPendingRequests;
            return this;
        }

        @NotNull
        public Builder setServerHost(InetAddress host) {
            this.host = host;
            return this;
        }

        @NotNull
        public Builder setServerPort(int port) {
            this.port = port;
            return this;
        }

        @NotNull
        public Builder setBossGroup(@NotNull EventLoopGroup bossGroup) {
            this.bossGroup = bossGroup;
            return this;
        }

        @NotNull
        public Builder setChildGroup(@NotNull EventLoopGroup childGroup) {
            this.childGroup = childGroup;
            return this;
        }

        @NotNull
        public Builder setInitTimeout(long initTimeout) {
            this.initTimeout = initTimeout;
            return this;
        }

        @NotNull
        public Builder setResetOnTimeoutLimit(int resetOnTimeoutLimit) {
            this.resetOnTimeoutLimit = resetOnTimeoutLimit;
            return this;
        }

        @NotNull
        public Builder setTracer(Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        @NotNull
        public Builder setTracingContext(TracingContext tracingContext) {
            this.tracingContext = tracingContext;
            return this;
        }

        @NotNull
        public TChannel build() {
            logger.debug(useEpoll ? "Using native epoll transport" : "Using NIO transport");
            return new TChannel(this);
        }

        @NotNull
        private Bootstrap bootstrap(@NotNull TChannel topChannel) {
            return ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.childGroup)).channel(useEpoll ? EpollSocketChannel.class : NioSocketChannel.class)).handler(this.channelInitializer(false, topChannel))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).validate();
        }

        @NotNull
        private ServerBootstrap serverBootstrap(@NotNull TChannel topChannel) {
            return ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.childGroup).channel(useEpoll ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).option(ChannelOption.SO_BACKLOG, (Object)128)).childHandler(this.channelInitializer(true, topChannel)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).validate();
        }

        @NotNull
        private ChannelInitializer<SocketChannel> channelInitializer(final boolean isServer, final @NotNull TChannel topChannel) {
            return new ChannelInitializer<SocketChannel>(){

                protected void initChannel(@NotNull SocketChannel ch) throws Exception {
                    ch.pipeline().addLast("FrameDecoder", (ChannelHandler)new TChannelLengthFieldBasedFrameDecoder());
                    if (isServer) {
                        ch.pipeline().addLast("InitRequestHandler", (ChannelHandler)new InitRequestHandler(topChannel.getPeerManager()));
                    } else {
                        ch.pipeline().addLast("InitRequestInitiator", (ChannelHandler)new InitRequestInitiator(topChannel.getPeerManager()));
                    }
                    ch.pipeline().addLast("MessageDefragmenter", (ChannelHandler)new MessageDefragmenter());
                    ch.pipeline().addLast("MessageFragmenter", (ChannelHandler)new MessageFragmenter());
                    ch.pipeline().addLast("RequestRouter", topChannel.getCustomRequestRouter() != null ? topChannel.getCustomRequestRouter() : new RequestRouter(topChannel, Builder.this.getExecutorService()));
                    ch.pipeline().addLast("ResponseRouter", (ChannelHandler)new ResponseRouter(topChannel, Builder.this.timer));
                    ch.pipeline().addLast("ChannelRegistrar", (ChannelHandler)new ChannelRegistrar(topChannel.getPeerManager()));
                }
            };
        }
    }
}

