/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.api;

import com.google.common.collect.ImmutableMap;
import com.uber.tchannel.api.TChannel;
import com.uber.tchannel.api.TFuture;
import com.uber.tchannel.api.errors.TChannelConnectionTimeout;
import com.uber.tchannel.api.errors.TChannelError;
import com.uber.tchannel.api.errors.TChannelNoPeerAvailable;
import com.uber.tchannel.api.handlers.HealthCheckRequestHandler;
import com.uber.tchannel.api.handlers.RequestHandler;
import com.uber.tchannel.channels.Connection;
import com.uber.tchannel.channels.PeerManager;
import com.uber.tchannel.channels.SubPeer;
import com.uber.tchannel.errors.ErrorType;
import com.uber.tchannel.handlers.OutRequest;
import com.uber.tchannel.handlers.ResponseRouter;
import com.uber.tchannel.headers.ArgScheme;
import com.uber.tchannel.messages.JSONSerializer;
import com.uber.tchannel.messages.JsonRequest;
import com.uber.tchannel.messages.JsonResponse;
import com.uber.tchannel.messages.RawRequest;
import com.uber.tchannel.messages.RawResponse;
import com.uber.tchannel.messages.Request;
import com.uber.tchannel.messages.Response;
import com.uber.tchannel.messages.Serializer;
import com.uber.tchannel.messages.ThriftRequest;
import com.uber.tchannel.messages.ThriftResponse;
import com.uber.tchannel.messages.ThriftSerializer;
import com.uber.tchannel.tracing.Tracing;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SubChannel {
    private final String service;
    @NotNull
    private final TChannel topChannel;
    @NotNull
    private final PeerManager peerManager;
    private final long initTimeout;
    private final Connection.Direction preferredDirection;
    @NotNull
    private final List<SubPeer> peers = new ArrayList<SubPeer>();
    @NotNull
    private final Map<String, RequestHandler> requestHandlers = new ConcurrentHashMap<String, RequestHandler>();
    private static final ImmutableMap<ArgScheme, Serializer.SerializerInterface> DEFAULT_SERIALIZERS = ImmutableMap.of((Object)((Object)ArgScheme.JSON), (Object)new JSONSerializer(), (Object)((Object)ArgScheme.THRIFT), (Object)new ThriftSerializer());
    private final Serializer serializer = new Serializer((Map<ArgScheme, Serializer.SerializerInterface>)DEFAULT_SERIALIZERS);

    public SubChannel(String service, @NotNull TChannel topChannel) {
        this(service, topChannel, Connection.Direction.NONE);
    }

    public SubChannel(String service, @NotNull TChannel topChannel, Connection.Direction preferredDirection) {
        this.service = service;
        this.topChannel = topChannel;
        this.peerManager = topChannel.getPeerManager();
        this.initTimeout = topChannel.getInitTimeout();
        this.preferredDirection = preferredDirection;
    }

    public String getServiceName() {
        return this.service;
    }

    @NotNull
    public PeerManager getPeerManager() {
        return this.peerManager;
    }

    @NotNull
    public SubChannel register(@NotNull String endpoint, @NotNull RequestHandler requestHandler) {
        this.requestHandlers.put(endpoint, requestHandler);
        return this;
    }

    @Deprecated
    @NotNull
    public SubChannel registerHealthHanlder() {
        return this.registerHealthHandler();
    }

    @NotNull
    public SubChannel registerHealthHandler() {
        return this.registerHealthHandler(new HealthCheckRequestHandler());
    }

    @NotNull
    public SubChannel registerHealthHandler(HealthCheckRequestHandler healthHandler) {
        return this.register("Meta::health", healthHandler);
    }

    @Nullable
    public RequestHandler getRequestHandler(@Nullable String endpoint) {
        return this.requestHandlers.get(endpoint);
    }

    public Connection.Direction getPreferredDirection() {
        return this.preferredDirection;
    }

    @NotNull
    public SubChannel setPeers(@NotNull List<InetSocketAddress> peers) {
        for (InetSocketAddress peer : peers) {
            this.peers.add(new SubPeer(peer, this));
        }
        return this;
    }

    @Nullable
    public SubPeer choosePeer(@NotNull OutRequest<?> outRequest) {
        boolean stop;
        int start;
        if (this.peers.isEmpty()) {
            return null;
        }
        int i = start = new Random().nextInt(this.peers.size());
        SubPeer res = null;
        do {
            SubPeer peer;
            if (!(stop = (peer = this.peers.get(i = (i + 1) % this.peers.size())).updateScore(outRequest)) && res != null && !(peer.getScore() > res.getScore())) continue;
            res = peer;
        } while (!stop && i != start);
        outRequest.setUsedPeer(res.getRemoteAddress());
        return res;
    }

    @Nullable
    public Connection connect(@NotNull OutRequest<?> outRequest) {
        SubPeer peer = this.choosePeer(outRequest);
        if (peer == null) {
            return null;
        }
        Connection conn = peer.getPreferredConnection();
        if (conn == null) {
            conn = peer.connectTo();
        }
        return conn;
    }

    public boolean sendOutRequest(OutRequest<?> outRequest) {
        boolean res;
        block1: {
            res = false;
            do {
                if (outRequest.shouldRetry()) continue;
                outRequest.setFuture();
                break block1;
            } while (!this.sendOutRequest(outRequest, this.connect(outRequest)));
            res = true;
        }
        return res;
    }

    public <T, U> TFuture<ThriftResponse<U>> send(ThriftRequest<T> request, InetAddress host, int port) throws TChannelError {
        request.setTransportHeader("cn", this.topChannel.getServiceName());
        return this.sendRequest(request, host, port);
    }

    public <T, U> TFuture<ThriftResponse<U>> send(ThriftRequest<T> request) throws TChannelError {
        return this.send(request, null, 0);
    }

    public <T, U> TFuture<JsonResponse<U>> send(JsonRequest<T> request, InetAddress host, int port) {
        request.setTransportHeader("cn", this.topChannel.getServiceName());
        return this.sendRequest(request, host, port);
    }

    public <T, U> TFuture<JsonResponse<U>> send(JsonRequest<T> request) {
        return this.send(request, null, 0);
    }

    public TFuture<RawResponse> send(RawRequest request, InetAddress host, int port) {
        request.setTransportHeader("cn", this.topChannel.getServiceName());
        return this.sendRequest(request, host, port);
    }

    public TFuture<RawResponse> send(RawRequest request) {
        return this.send(request, null, 0);
    }

    protected <V extends Response> TFuture<V> sendRequest(Request request, InetAddress host, int port) {
        OutRequest outRequest = new OutRequest(this, request, this.topChannel.getTracingContext());
        if (host != null) {
            Connection conn = this.peerManager.findOrNew(new InetSocketAddress(host, port));
            outRequest.disableRetry();
            if (!this.sendOutRequest(outRequest, conn)) {
                outRequest.setFuture();
            }
        } else if (this.peers.isEmpty()) {
            outRequest.setLastError(ErrorType.BadRequest, new TChannelNoPeerAvailable());
            outRequest.setFuture();
        } else {
            this.sendOutRequest(outRequest);
        }
        return outRequest.getFuture();
    }

    private boolean sendOutRequest(@NotNull OutRequest<?> outRequest, @Nullable Connection connection) {
        long initTimeout;
        Request request = outRequest.getRequest();
        try {
            Tracing.startOutboundSpan(outRequest, this.topChannel.getTracer(), this.topChannel.getTracingContext());
        }
        catch (RuntimeException e) {
            outRequest.setLastError(ErrorType.BadRequest, e);
            outRequest.setFuture();
            return false;
        }
        if (request.getArgScheme() == null) {
            request.setArgScheme(ArgScheme.RAW);
            outRequest.setLastError(ErrorType.BadRequest, "Expect call request to have Arg Scheme specified");
            outRequest.setFuture();
            return false;
        }
        if (request.getRetryFlags() == null) {
            request.setRetryFlags("c");
        }
        if ((initTimeout = this.initTimeout) <= 0L) {
            initTimeout = request.getTimeout();
        }
        if (connection == null) {
            outRequest.setLastError(ErrorType.BadRequest, new TChannelNoPeerAvailable());
            outRequest.setFuture();
            return false;
        }
        if (!connection.waitForIdentified(initTimeout)) {
            connection.clean();
            if (connection.lastError() != null) {
                outRequest.setLastError(ErrorType.NetworkError, connection.lastError());
            } else {
                String logMessage = String.format("%s/%s::%s", connection.getPeer().remoteAddress, request.getService(), request.getEndpoint());
                outRequest.setLastError(ErrorType.NetworkError, new TChannelConnectionTimeout(logMessage));
            }
            return false;
        }
        ResponseRouter router = (ResponseRouter)connection.channel().pipeline().get(ResponseRouter.class);
        return router.expectResponse(outRequest);
    }
}

