/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.jarinfer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.PhantomClass;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.core.util.config.AnalysisScopeReader;
import com.ibm.wala.core.util.warnings.Warnings;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.ClassHierarchyFactory;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.config.FileOfClasses;
import com.ibm.wala.util.config.SetOfClasses;
import com.uber.nullaway.jarinfer.BytecodeAnnotator;
import com.uber.nullaway.jarinfer.DefinitelyDerefedParams;
import com.uber.nullaway.jarinfer.MethodAnnotationsRecord;
import com.uber.nullaway.jarinfer.MethodParamAnnotations;
import com.uber.nullaway.jarinfer.MethodReturnAnnotations;
import com.uber.nullaway.jarinfer.StubxWriter;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;

public class DefinitelyDerefedParamsDriver {
    private static boolean DEBUG = false;
    private static boolean VERBOSE = false;
    String lastOutPath = "";
    private long analyzedBytes = 0L;
    private long analysisStartTime = 0L;
    private MethodParamAnnotations nonnullParams = new MethodParamAnnotations();
    private MethodReturnAnnotations nullableReturns = new MethodReturnAnnotations();
    private boolean annotateBytecode = false;
    private boolean stripJarSignatures = false;
    private static final String DEFAULT_ASTUBX_LOCATION = "META-INF/nullaway/jarinfer.astubx";
    private static final String ASTUBX_JAR_SUFFIX = ".astubx.jar";
    private static final String DEFAULT_EXCLUSIONS = "org\\/objectweb\\/asm\\/.*";

    private static void LOG(boolean cond, String tag, String msg) {
        if (cond) {
            System.out.println("[JI " + tag + "] " + msg);
        }
    }

    private void accountCodeBytes(IMethod mtd) {
        if (mtd instanceof ShrikeCTMethod) {
            this.analyzedBytes += (long)((ShrikeCTMethod)mtd).getBytecodes().length;
        }
    }

    private DefinitelyDerefedParams getAnalysisDriver(IMethod mtd, AnalysisOptions options, AnalysisCache cache) {
        IR ir = cache.getIRFactory().makeIR(mtd, (Context)Everywhere.EVERYWHERE, options.getSSAOptions());
        SSACFG cfg = ir.getControlFlowGraph();
        this.accountCodeBytes(mtd);
        return new DefinitelyDerefedParams(mtd, ir, (ControlFlowGraph<SSAInstruction, ISSABasicBlock>)cfg);
    }

    MethodParamAnnotations run(String inPaths, String pkgName, boolean includeNonPublicClasses) throws IOException, ClassHierarchyException, IllegalArgumentException {
        Object outPath = "";
        String firstInPath = inPaths.split(",")[0];
        if (firstInPath.endsWith(".jar") || firstInPath.endsWith(".aar")) {
            outPath = FilenameUtils.getFullPath((String)firstInPath) + FilenameUtils.getBaseName((String)firstInPath) + ASTUBX_JAR_SUFFIX;
        } else if (new File(firstInPath).exists()) {
            outPath = FilenameUtils.getFullPath((String)firstInPath) + DEFAULT_ASTUBX_LOCATION;
        }
        return this.run(inPaths, pkgName, (String)outPath, false, false, includeNonPublicClasses, DEBUG, VERBOSE);
    }

    MethodParamAnnotations run(String inPaths, String pkgName) throws IOException, ClassHierarchyException, IllegalArgumentException {
        return this.run(inPaths, pkgName, false);
    }

    MethodParamAnnotations runAndAnnotate(String inPaths, String pkgName, String outPath, boolean stripJarSignatures) throws IOException, ClassHierarchyException {
        return this.run(inPaths, pkgName, outPath, true, stripJarSignatures, false, DEBUG, VERBOSE);
    }

    MethodParamAnnotations runAndAnnotate(String inPaths, String pkgName, String outPath) throws IOException, ClassHierarchyException {
        return this.runAndAnnotate(inPaths, pkgName, outPath, false);
    }

    public MethodParamAnnotations run(String inPaths, String pkgName, String outPath, boolean annotateBytecode, boolean stripJarSignatures, boolean includeNonPublicClasses, boolean dbg, boolean vbs) throws IOException, ClassHierarchyException {
        DEBUG = dbg;
        VERBOSE = vbs;
        this.annotateBytecode = annotateBytecode;
        this.stripJarSignatures = stripJarSignatures;
        HashSet<String> setInPaths = new HashSet<String>(Arrays.asList(inPaths.split(",")));
        this.analysisStartTime = System.currentTimeMillis();
        for (String inPath : setInPaths) {
            this.analyzeFile(pkgName, inPath, includeNonPublicClasses);
            if (!this.annotateBytecode) continue;
            Object outFile = outPath;
            if (setInPaths.size() > 1) {
                outFile = outPath + "/" + FilenameUtils.getBaseName((String)inPath) + "-annotated." + FilenameUtils.getExtension((String)inPath);
            }
            this.writeAnnotations(inPath, (String)outFile);
        }
        if (!this.annotateBytecode) {
            new File(outPath).getParentFile().mkdirs();
            if (outPath.endsWith(".astubx")) {
                this.writeModel(new DataOutputStream(new FileOutputStream(outPath)));
            } else {
                this.writeModelJAR(outPath);
            }
        }
        this.lastOutPath = outPath;
        return this.nonnullParams;
    }

    private boolean bytecodeHasAnyDereferences(IMethod mtd) throws InvalidClassFileException {
        return !CodeScanner.getFieldsRead((IMethod)mtd).isEmpty() || !CodeScanner.getFieldsWritten((IMethod)mtd).isEmpty() || !CodeScanner.getCallSites((IMethod)mtd).isEmpty();
    }

    private void analyzeFile(String pkgName, String inPath, boolean includeNonPublicClasses) throws IOException, ClassHierarchyException {
        InputStream jarIS = null;
        if (inPath.endsWith(".jar") || inPath.endsWith(".aar") ? (jarIS = DefinitelyDerefedParamsDriver.getInputStream(inPath)) == null : !new File(inPath).exists()) {
            return;
        }
        AnalysisScope scope = AnalysisScopeReader.instance.makeBasePrimordialScope(null);
        scope.setExclusions((SetOfClasses)new FileOfClasses((InputStream)new ByteArrayInputStream(DEFAULT_EXCLUSIONS.getBytes(StandardCharsets.UTF_8))));
        if (jarIS != null) {
            scope.addInputStreamForJarToScope(ClassLoaderReference.Application, jarIS);
        } else {
            AnalysisScopeReader.instance.addClassPathToScope(inPath, scope, ClassLoaderReference.Application);
        }
        AnalysisOptions options = new AnalysisOptions(scope, null);
        AnalysisCacheImpl cache = new AnalysisCacheImpl();
        ClassHierarchy cha = ClassHierarchyFactory.makeWithRoot((AnalysisScope)scope);
        Warnings.clear();
        for (IClassLoader cldr : cha.getLoaders()) {
            if (cldr.getName().toString().equals("Primordial")) continue;
            for (IClass cls : Iterator2Iterable.make((Iterator)cldr.iterateAllClasses())) {
                if (cls instanceof PhantomClass || !pkgName.isEmpty() && !cls.getName().toString().startsWith(pkgName) || !cls.isPublic() && !includeNonPublicClasses) continue;
                DefinitelyDerefedParamsDriver.LOG(DEBUG, "DEBUG", "analyzing class: " + cls.getName().toString());
                for (IMethod mtd : Iterator2Iterable.make(cls.getDeclaredMethods().iterator())) {
                    if (!this.shouldCheckMethod(mtd)) continue;
                    Preconditions.checkNotNull((Object)mtd, (Object)"method not found");
                    DefinitelyDerefedParams analysisDriver = null;
                    String sign = "";
                    try {
                        if (mtd.getNumberOfParameters() > (mtd.isStatic() ? 0 : 1) && this.bytecodeHasAnyDereferences(mtd)) {
                            analysisDriver = this.getAnalysisDriver(mtd, options, (AnalysisCache)cache);
                            Set<Integer> result = analysisDriver.analyze();
                            sign = this.getSignature(mtd);
                            DefinitelyDerefedParamsDriver.LOG(DEBUG, "DEBUG", "analyzed method: " + sign);
                            if (!result.isEmpty() || DEBUG) {
                                this.nonnullParams.put(sign, result);
                                DefinitelyDerefedParamsDriver.LOG(DEBUG, "DEBUG", "Inferred Nonnull param for method: " + sign + " = " + result.toString());
                            }
                        }
                        this.analyzeReturnValue(options, (AnalysisCache)cache, mtd, analysisDriver, sign);
                    }
                    catch (Exception e) {
                        DefinitelyDerefedParamsDriver.LOG(DEBUG, "DEBUG", "Exception while scanning bytecodes for " + mtd + " " + e.getMessage());
                    }
                }
            }
        }
        long endTime = System.currentTimeMillis();
        DefinitelyDerefedParamsDriver.LOG(VERBOSE, "Stats", inPath + " >> time(ms): " + (endTime - this.analysisStartTime) + ", bytecode size: " + this.analyzedBytes + ", rate (ms/KB): " + (this.analyzedBytes > 0L ? (endTime - this.analysisStartTime) * 1000L / this.analyzedBytes : 0L));
    }

    private void analyzeReturnValue(AnalysisOptions options, AnalysisCache cache, IMethod mtd, DefinitelyDerefedParams analysisDriver, String sign) {
        if (!mtd.getReturnType().isPrimitiveType()) {
            if (analysisDriver == null) {
                analysisDriver = this.getAnalysisDriver(mtd, options, cache);
            }
            if (analysisDriver.analyzeReturnType() == DefinitelyDerefedParams.NullnessHint.NULLABLE) {
                if (sign.isEmpty()) {
                    sign = this.getSignature(mtd);
                }
                this.nullableReturns.add(sign);
                DefinitelyDerefedParamsDriver.LOG(DEBUG, "DEBUG", "Inferred Nullable method return: " + sign);
            }
        }
    }

    private boolean shouldCheckMethod(IMethod mtd) {
        return !mtd.isPrivate() && !mtd.isAbstract() && !mtd.isNative() && !DefinitelyDerefedParamsDriver.isAllPrimitiveTypes(mtd) && !mtd.getDeclaringClass().getClassLoader().getName().toString().equals("Primordial");
    }

    private static boolean isAllPrimitiveTypes(IMethod mtd) {
        int i;
        if (!mtd.getReturnType().isPrimitiveType()) {
            return false;
        }
        int n = i = mtd.isStatic() ? 0 : 1;
        while (i < mtd.getNumberOfParameters()) {
            if (!mtd.getParameterType(i).isPrimitiveType()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static InputStream getInputStream(String libPath) throws IOException {
        Preconditions.checkArgument(((libPath.endsWith(".jar") || libPath.endsWith(".aar")) && Files.exists(Paths.get(libPath, new String[0]), new LinkOption[0]) ? 1 : 0) != 0, (Object)("invalid library path! " + libPath));
        DefinitelyDerefedParamsDriver.LOG(VERBOSE, "Info", "opening library: " + libPath + "...");
        FileInputStream jarIS = null;
        if (libPath.endsWith(".jar")) {
            jarIS = new FileInputStream(libPath);
        } else if (libPath.endsWith(".aar")) {
            ZipFile aar = new ZipFile(libPath);
            ZipEntry jarEntry = aar.getEntry("classes.jar");
            jarIS = jarEntry == null ? null : aar.getInputStream(jarEntry);
        }
        return jarIS;
    }

    private void writeModelJAR(String outPath) throws IOException {
        Preconditions.checkArgument((boolean)outPath.endsWith(ASTUBX_JAR_SUFFIX), (Object)("invalid model file path! " + outPath));
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outPath));
        if (!this.nonnullParams.isEmpty()) {
            ZipEntry entry = new ZipEntry(DEFAULT_ASTUBX_LOCATION);
            entry.setTime(0L);
            entry.setCreationTime(FileTime.fromMillis(0L));
            zos.putNextEntry(entry);
            this.writeModel(new DataOutputStream(zos));
            zos.closeEntry();
        }
        zos.close();
        DefinitelyDerefedParamsDriver.LOG(VERBOSE, "Info", "wrote model to: " + outPath);
    }

    private void writeModel(DataOutputStream out) throws IOException {
        ImmutableMap importedAnnotations = ImmutableMap.builder().put((Object)"Nonnull", (Object)"javax.annotation.Nonnull").put((Object)"Nullable", (Object)"javax.annotation.Nullable").build();
        HashMap<String, Set<String>> packageAnnotations = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> typeAnnotations = new HashMap<String, Set<String>>();
        LinkedHashMap<String, MethodAnnotationsRecord> methodRecords = new LinkedHashMap<String, MethodAnnotationsRecord>();
        for (Map.Entry entry : this.nonnullParams.entrySet()) {
            String sign = (String)entry.getKey();
            Set ddParams = (Set)entry.getValue();
            if (ddParams.isEmpty()) continue;
            HashMap<Integer, ImmutableSet> argAnnotation = new HashMap<Integer, ImmutableSet>();
            for (Integer param : ddParams) {
                argAnnotation.put(param, ImmutableSet.of((Object)"Nonnull"));
            }
            methodRecords.put(sign, new MethodAnnotationsRecord((ImmutableSet<String>)(this.nullableReturns.contains(sign) ? ImmutableSet.of((Object)"Nullable") : ImmutableSet.of()), (ImmutableMap<Integer, ImmutableSet<String>>)ImmutableMap.copyOf(argAnnotation)));
            this.nullableReturns.remove(sign);
        }
        for (String nullableReturnMethodSign : Iterator2Iterable.make(this.nullableReturns.iterator())) {
            methodRecords.put(nullableReturnMethodSign, new MethodAnnotationsRecord((ImmutableSet<String>)ImmutableSet.of((Object)"Nullable"), (ImmutableMap<Integer, ImmutableSet<String>>)ImmutableMap.of()));
        }
        StubxWriter.write(out, (Map<String, String>)importedAnnotations, packageAnnotations, typeAnnotations, methodRecords);
    }

    private void writeAnnotations(String inPath, String outFile) throws IOException {
        Preconditions.checkArgument((inPath.endsWith(".jar") || inPath.endsWith(".aar") || inPath.endsWith(".class") ? 1 : 0) != 0, (Object)("invalid input path - " + inPath));
        DefinitelyDerefedParamsDriver.LOG(DEBUG, "DEBUG", "Writing Annotations to " + outFile);
        new File(outFile).getParentFile().mkdirs();
        if (inPath.endsWith(".jar")) {
            JarFile jar = new JarFile(inPath);
            JarOutputStream jarOS = new JarOutputStream(new FileOutputStream(outFile));
            BytecodeAnnotator.annotateBytecodeInJar(jar, jarOS, this.nonnullParams, this.nullableReturns, this.stripJarSignatures, DEBUG);
            jarOS.close();
        } else if (inPath.endsWith(".aar")) {
            ZipFile zip = new ZipFile(inPath);
            ZipOutputStream zipOS = new ZipOutputStream(new FileOutputStream(outFile));
            BytecodeAnnotator.annotateBytecodeInAar(zip, zipOS, this.nonnullParams, this.nullableReturns, this.stripJarSignatures, DEBUG);
            zipOS.close();
        } else {
            FileInputStream is = new FileInputStream(inPath);
            FileOutputStream os = new FileOutputStream(outFile);
            BytecodeAnnotator.annotateBytecodeInClass(is, os, this.nonnullParams, this.nullableReturns, DEBUG);
            ((OutputStream)os).close();
        }
    }

    private String getSignature(IMethod mtd) {
        return this.annotateBytecode ? mtd.getSignature() : DefinitelyDerefedParamsDriver.getAstubxSignature(mtd);
    }

    private static String getAstubxSignature(IMethod mtd) {
        int argi;
        String classType = mtd.getDeclaringClass().getName().toString().replaceAll("/", "\\.").substring(1);
        classType = classType.replaceAll("\\$", "\\.");
        String returnType = mtd.isInit() ? null : DefinitelyDerefedParamsDriver.getSimpleTypeName(mtd.getReturnType());
        Object strArgTypes = "";
        int n = argi = mtd.isStatic() ? 0 : 1;
        while (argi < mtd.getNumberOfParameters()) {
            strArgTypes = (String)strArgTypes + DefinitelyDerefedParamsDriver.getSimpleTypeName(mtd.getParameterType(argi));
            if (argi < mtd.getNumberOfParameters() - 1) {
                strArgTypes = (String)strArgTypes + ", ";
            }
            ++argi;
        }
        return classType + ":" + (String)(returnType == null ? "void " : returnType + " ") + mtd.getName().toString() + "(" + (String)strArgTypes + ")";
    }

    private static String getSimpleTypeName(TypeReference typ) {
        ImmutableMap mapFullTypeName = ImmutableMap.builder().put((Object)"B", (Object)"byte").put((Object)"C", (Object)"char").put((Object)"D", (Object)"double").put((Object)"F", (Object)"float").put((Object)"I", (Object)"int").put((Object)"J", (Object)"long").put((Object)"S", (Object)"short").put((Object)"Z", (Object)"boolean").build();
        if (typ.isArrayType()) {
            return "Array";
        }
        String typName = typ.getName().toString();
        if (typName.startsWith("L")) {
            typName = typName.split("<")[0].substring(1);
            typName = typName.substring(typName.lastIndexOf(47) + 1);
            typName = typName.substring(typName.lastIndexOf(36) + 1);
        } else {
            typName = (String)mapFullTypeName.get(typName);
        }
        return typName;
    }
}

