/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.jarinfer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cfg.ExceptionPrunedCFG;
import com.ibm.wala.ipa.cfg.PrunedCFG;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.GraphUtil;
import com.ibm.wala.util.graph.dominators.Dominators;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DefinitelyDerefedParams {
    private static final boolean DEBUG = false;
    private boolean USE_EXTENDED_APPROACH = true;
    private final IMethod method;
    private final IR ir;
    private final ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg;
    private PrunedCFG<SSAInstruction, ISSABasicBlock> prunedCFG;
    private static final ImmutableMap<String, Integer> NULL_TEST_APIS = new ImmutableMap.Builder().put((Object)"com.google.common.base.Preconditions.checkNotNull(Ljava/lang/Object;)Ljava/lang/Object;", (Object)0).put((Object)"java.util.Objects.requireNonNull(Ljava/lang/Object;)Ljava/lang/Object;", (Object)0).put((Object)"org.junit.Assert.assertNotNull(Ljava/lang/Object;)V", (Object)0).put((Object)"org.junit.Assert.assertNotNull(Ljava/lang/String;Ljava/lang/Object;)V", (Object)1).put((Object)"org.junit.jupiter.api.Assertions.assertNotNull(Ljava/lang/Object;)V", (Object)0).put((Object)"org.junit.jupiter.api.Assertions.assertNotNull(Ljava/lang/Object;Ljava/lang/String;)V", (Object)1).put((Object)"org.junit.jupiter.api.Assertions.assertNotNull(Ljava/lang/Object;Ljava/util/function/Supplier<String>;)V", (Object)1).build();

    private static void LOG(boolean cond, String tag, String msg) {
        if (cond) {
            System.out.println("[JI " + tag + "] " + msg);
        }
    }

    DefinitelyDerefedParams(IMethod method, IR ir, ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg) {
        this.method = method;
        this.ir = ir;
        this.cfg = cfg;
        this.prunedCFG = null;
    }

    Set<Integer> analyze() {
        DefinitelyDerefedParams.LOG(false, "DEBUG", "@ " + this.method.getSignature());
        this.prunedCFG = ExceptionPrunedCFG.make(this.cfg);
        if (this.prunedCFG.getNumberOfNodes() == 2 && this.prunedCFG.containsNode((Object)((ISSABasicBlock)this.cfg.entry())) && this.prunedCFG.containsNode((Object)((ISSABasicBlock)this.cfg.exit())) && GraphUtil.countEdges(this.prunedCFG) == 0L) {
            return new HashSet<Integer>();
        }
        int numParam = this.ir.getSymbolTable().getNumberOfParameters();
        int firstParamIndex = this.method.isStatic() ? 1 : 2;
        Set<Integer> derefedParamList = this.USE_EXTENDED_APPROACH ? this.computeDerefParamList(numParam, firstParamIndex) : this.computeDerefParamListUsingPDom(numParam, firstParamIndex);
        return derefedParamList;
    }

    private Set<Integer> computeDerefParamList(int numParam, int firstParamIndex) {
        HashSet<Integer> derefedParamList = new HashSet<Integer>();
        HashMap blockToDerefSetMap = new HashMap();
        this.prunedCFG.forEach(basicBlock -> {
            HashSet<Integer> derefParamSet = new HashSet<Integer>();
            blockToDerefSetMap.put(basicBlock, derefParamSet);
            this.checkForUseOfParams((Set<Integer>)derefParamSet, numParam, firstParamIndex, (ISSABasicBlock)basicBlock);
        });
        for (int i = firstParamIndex; i <= numParam; ++i) {
            Integer param = i - 1;
            if (DFS.getReachableNodes(this.prunedCFG, (Collection)ImmutableList.of((Object)((ISSABasicBlock)this.prunedCFG.entry())), basicBlock -> !((Set)blockToDerefSetMap.get(basicBlock)).contains(param)).contains(this.prunedCFG.exit())) continue;
            derefedParamList.add(param);
        }
        return derefedParamList;
    }

    private Set<Integer> computeDerefParamListUsingPDom(int numParam, int firstParamIndex) {
        HashSet<Integer> derefedParamList = new HashSet<Integer>();
        DefinitelyDerefedParams.LOG(false, "DEBUG", "\tbuilding dominator tree...");
        Graph domTree = Dominators.make(this.prunedCFG, (Object)((ISSABasicBlock)this.prunedCFG.entry())).dominatorTree();
        Graph pdomTree = GraphInverter.invert((Graph)domTree);
        DefinitelyDerefedParams.LOG(false, "DEBUG", "post-dominator tree:" + pdomTree.toString());
        DefinitelyDerefedParams.LOG(false, "DEBUG", "\tfinding dereferenced params...");
        ArrayList<ISSABasicBlock> nodeQueue = new ArrayList<ISSABasicBlock>();
        nodeQueue.add((ISSABasicBlock)this.prunedCFG.exit());
        DefinitelyDerefedParams.LOG(false, "DEBUG", "param value numbers : " + firstParamIndex + " ... " + numParam);
        while (!nodeQueue.isEmpty()) {
            ISSABasicBlock node = (ISSABasicBlock)nodeQueue.get(0);
            nodeQueue.remove(node);
            this.checkForUseOfParams(derefedParamList, numParam, firstParamIndex, node);
            for (ISSABasicBlock succ : Iterator2Iterable.make((Iterator)pdomTree.getSuccNodes((Object)node))) {
                nodeQueue.add(succ);
            }
        }
        DefinitelyDerefedParams.LOG(false, "DEBUG", "\tdone...");
        return derefedParamList;
    }

    private void checkForUseOfParams(Set<Integer> derefedParamList, int numParam, int firstParamIndex, ISSABasicBlock node) {
        if (!node.isEntryBlock() && !node.isExitBlock()) {
            DefinitelyDerefedParams.LOG(false, "DEBUG", ">> bb: " + node.getNumber());
            for (int i = node.getFirstInstructionIndex(); i <= node.getLastInstructionIndex(); ++i) {
                SSAInstruction instr = this.ir.getInstructions()[i];
                if (instr == null) continue;
                DefinitelyDerefedParams.LOG(false, "DEBUG", "\tinst: " + instr.toString());
                int derefValueNumber = -1;
                if (instr instanceof SSAGetInstruction && !((SSAGetInstruction)instr).isStatic()) {
                    derefValueNumber = ((SSAGetInstruction)instr).getRef();
                } else if (instr instanceof SSAPutInstruction && !((SSAPutInstruction)instr).isStatic()) {
                    derefValueNumber = ((SSAPutInstruction)instr).getRef();
                } else if (instr instanceof SSAAbstractInvokeInstruction) {
                    SSAAbstractInvokeInstruction callInst = (SSAAbstractInvokeInstruction)instr;
                    String sign = callInst.getDeclaredTarget().getSignature();
                    if (((SSAAbstractInvokeInstruction)instr).isStatic()) {
                        if (NULL_TEST_APIS.containsKey((Object)sign)) {
                            derefValueNumber = callInst.getUse(((Integer)NULL_TEST_APIS.get((Object)sign)).intValue());
                        }
                    } else {
                        Preconditions.checkArgument((!NULL_TEST_APIS.containsKey((Object)sign) ? 1 : 0) != 0, (Object)("Add support for non-static NULL_TEST_APIS : " + sign));
                        derefValueNumber = ((SSAAbstractInvokeInstruction)instr).getReceiver();
                    }
                }
                if (derefValueNumber < firstParamIndex || derefValueNumber > numParam) continue;
                DefinitelyDerefedParams.LOG(false, "DEBUG", "\t\tderefed param : " + derefValueNumber);
                derefedParamList.add(derefValueNumber - 1);
            }
        }
    }

    NullnessHint analyzeReturnType() {
        if (this.method.getReturnType().isPrimitiveType()) {
            DefinitelyDerefedParams.LOG(false, "DEBUG", "Skipping method with primitive return type: " + this.method.getSignature());
            return NullnessHint.UNKNOWN;
        }
        DefinitelyDerefedParams.LOG(false, "DEBUG", "@ Return type analysis for: " + this.method.getSignature());
        if (this.prunedCFG == null) {
            this.prunedCFG = ExceptionPrunedCFG.make(this.cfg);
        }
        if (this.prunedCFG.getNumberOfNodes() == 2 && this.prunedCFG.containsNode((Object)((ISSABasicBlock)this.cfg.entry())) && this.prunedCFG.containsNode((Object)((ISSABasicBlock)this.cfg.exit())) && GraphUtil.countEdges(this.prunedCFG) == 0L) {
            return NullnessHint.UNKNOWN;
        }
        for (ISSABasicBlock bb : this.prunedCFG.getNormalPredecessors((IBasicBlock)((ISSABasicBlock)this.prunedCFG.exit()))) {
            for (int i = bb.getFirstInstructionIndex(); i <= bb.getLastInstructionIndex(); ++i) {
                SSAInstruction instr = this.ir.getInstructions()[i];
                if (!(instr instanceof SSAReturnInstruction)) continue;
                SSAReturnInstruction retInstr = (SSAReturnInstruction)instr;
                if (!this.ir.getSymbolTable().isNullConstant(retInstr.getResult())) continue;
                DefinitelyDerefedParams.LOG(false, "DEBUG", "Nullable return in method: " + this.method.getSignature());
                return NullnessHint.NULLABLE;
            }
        }
        return NullnessHint.UNKNOWN;
    }

    public static enum NullnessHint {
        UNKNOWN,
        NULLABLE,
        NONNULL;

    }
}

