/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.jarinfer;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.uber.nullaway.jarinfer.MethodParamAnnotations;
import com.uber.nullaway.jarinfer.MethodReturnAnnotations;
import com.uber.nullaway.jarinfer.SignedJarException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public final class BytecodeAnnotator {
    private static boolean debug = false;
    public static final String javaxNullableDesc = "Ljavax/annotation/Nullable;";
    public static final String javaxNonnullDesc = "Ljavax/annotation/Nonnull;";
    public static final String androidNullableDesc = "Landroidx/annotation/Nullable;";
    public static final String androidNonnullDesc = "Landroidx/annotation/NonNull;";
    public static final ImmutableSet<String> NULLABLE_ANNOTATIONS = ImmutableSet.of((Object)"Ljavax/annotation/Nullable;", (Object)"Landroidx/annotation/Nullable;", (Object)"Landroid/support/annotation/Nullable;", (Object)"Lorg/jetbrains/annotations/Nullable;");
    public static final ImmutableSet<String> NONNULL_ANNOTATIONS = ImmutableSet.of((Object)"Ljavax/annotation/Nonnull;", (Object)"Landroidx/annotation/NonNull;", (Object)"Landroid/support/annotation/NonNull;", (Object)"Lorg/jetbrains/annotations/NotNull;");
    public static final Sets.SetView<String> NULLABILITY_ANNOTATIONS = Sets.union(NULLABLE_ANNOTATIONS, NONNULL_ANNOTATIONS);
    private static final String SIGNED_JAR_ERROR_MESSAGE = "JarInfer will not process signed jars by default. Please take one of the following actions:\n\t1) Remove the signature from the original jar before passing it to jarinfer,\n\t2) Pass the --strip-jar-signatures flag to JarInfer and the tool will remove signature metadata for you, or\n\t3) Exclude this jar from those being processed by JarInfer.";
    private static final String BASE64_PATTERN = "(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?";
    private static final String DIGEST_ENTRY_PATTERN = "Name: [A-Za-z0-9/\\$\\n\\s\\-\\.]+[A-Za-z0-9]\\nSHA-256-Digest: (?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?";

    private static void LOG(boolean cond, String tag, String msg) {
        if (cond) {
            System.out.println("[" + tag + "] " + msg);
        }
    }

    private static boolean annotationsShouldBeVisible(String nullableDesc) {
        if (nullableDesc.equals(javaxNullableDesc)) {
            return true;
        }
        if (nullableDesc.equals(androidNullableDesc)) {
            return false;
        }
        throw new Error("Unknown nullness annotation visibility");
    }

    private static boolean listHasNullnessAnnotations(List<AnnotationNode> annotationList) {
        if (annotationList != null) {
            for (AnnotationNode node : annotationList) {
                if (!NULLABILITY_ANNOTATIONS.contains((Object)node.desc)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasNullnessAnnotations(MethodNode method) {
        if (BytecodeAnnotator.listHasNullnessAnnotations(method.visibleAnnotations) || BytecodeAnnotator.listHasNullnessAnnotations(method.invisibleAnnotations)) {
            return true;
        }
        if (method.visibleParameterAnnotations != null) {
            for (List annotationList : method.visibleParameterAnnotations) {
                if (!BytecodeAnnotator.listHasNullnessAnnotations(annotationList)) continue;
                return true;
            }
        }
        if (method.invisibleParameterAnnotations != null) {
            for (List annotationList : method.invisibleParameterAnnotations) {
                if (!BytecodeAnnotator.listHasNullnessAnnotations(annotationList)) continue;
                return true;
            }
        }
        return false;
    }

    private static void annotateBytecode(InputStream is, OutputStream os, MethodParamAnnotations nonnullParams, MethodReturnAnnotations nullableReturns, String nullableDesc, String nonnullDesc) throws IOException {
        ClassReader cr = new ClassReader(is);
        ClassWriter cw = new ClassWriter(0);
        ClassNode cn = new ClassNode(458752);
        cr.accept((ClassVisitor)cn, 0);
        String className = cn.name.replace('/', '.');
        List methods = cn.methods;
        for (MethodNode method : methods) {
            Set params;
            if (BytecodeAnnotator.hasNullnessAnnotations(method)) continue;
            boolean visible = BytecodeAnnotator.annotationsShouldBeVisible(nullableDesc);
            String methodSignature = className + "." + method.name + method.desc;
            if (nullableReturns.contains(methodSignature)) {
                method.visitAnnotation(nullableDesc, visible);
                BytecodeAnnotator.LOG(debug, "DEBUG", "Added nullable return annotation for " + methodSignature);
            }
            if ((params = (Set)nonnullParams.get(methodSignature)) == null) continue;
            boolean isStatic = (method.access & 8) != 0;
            for (Integer param : params) {
                int paramNum = isStatic ? param : param - 1;
                method.visitParameterAnnotation(paramNum, nonnullDesc, visible);
                BytecodeAnnotator.LOG(debug, "DEBUG", "Added nonnull parameter annotation for #" + param + " in " + methodSignature);
            }
        }
        cn.accept((ClassVisitor)cw);
        os.write(cw.toByteArray());
    }

    public static void annotateBytecodeInClass(InputStream is, OutputStream os, MethodParamAnnotations nonnullParams, MethodReturnAnnotations nullableReturns, boolean debug) throws IOException {
        BytecodeAnnotator.debug = debug;
        BytecodeAnnotator.LOG(debug, "DEBUG", "nullableReturns: " + nullableReturns);
        BytecodeAnnotator.LOG(debug, "DEBUG", "nonnullParams: " + nonnullParams);
        BytecodeAnnotator.annotateBytecode(is, os, nonnullParams, nullableReturns, javaxNullableDesc, javaxNonnullDesc);
    }

    private static void copyAndAnnotateJarEntry(JarEntry jarEntry, InputStream is, JarOutputStream jarOS, MethodParamAnnotations nonnullParams, MethodReturnAnnotations nullableReturns, String nullableDesc, String nonnullDesc, boolean stripJarSignatures) throws IOException {
        String entryName = jarEntry.getName();
        if (entryName.endsWith(".class")) {
            jarOS.putNextEntry(new ZipEntry(jarEntry.getName()));
            BytecodeAnnotator.annotateBytecode(is, jarOS, nonnullParams, nullableReturns, nullableDesc, nonnullDesc);
        } else if (entryName.equals("META-INF/MANIFEST.MF")) {
            String manifestMinusDigests;
            String currentLine;
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            while ((currentLine = br.readLine()) != null) {
                stringBuilder.append(currentLine + "\n");
            }
            String manifestText = stringBuilder.toString();
            if (!manifestText.equals(manifestMinusDigests = manifestText.replaceAll(DIGEST_ENTRY_PATTERN, "")) && !stripJarSignatures) {
                throw new SignedJarException(SIGNED_JAR_ERROR_MESSAGE);
            }
            jarOS.putNextEntry(new ZipEntry(jarEntry.getName()));
            jarOS.write(manifestMinusDigests.getBytes(StandardCharsets.UTF_8));
        } else if (entryName.startsWith("META-INF/") && (entryName.endsWith(".DSA") || entryName.endsWith(".RSA") || entryName.endsWith(".SF"))) {
            if (!stripJarSignatures) {
                throw new SignedJarException(SIGNED_JAR_ERROR_MESSAGE);
            }
        } else {
            jarOS.putNextEntry(new ZipEntry(jarEntry.getName()));
            jarOS.write(IOUtils.toByteArray((InputStream)is));
        }
        jarOS.closeEntry();
    }

    public static void annotateBytecodeInJar(JarFile inputJar, JarOutputStream jarOS, MethodParamAnnotations nonnullParams, MethodReturnAnnotations nullableReturns, boolean stripJarSignatures, boolean debug) throws IOException {
        BytecodeAnnotator.debug = debug;
        BytecodeAnnotator.LOG(debug, "DEBUG", "nullableReturns: " + nullableReturns);
        BytecodeAnnotator.LOG(debug, "DEBUG", "nonnullParams: " + nonnullParams);
        for (JarEntry jarEntry : inputJar.stream()::iterator) {
            InputStream is = inputJar.getInputStream(jarEntry);
            BytecodeAnnotator.copyAndAnnotateJarEntry(jarEntry, is, jarOS, nonnullParams, nullableReturns, javaxNullableDesc, javaxNonnullDesc, stripJarSignatures);
        }
    }

    public static void annotateBytecodeInAar(ZipFile inputZip, ZipOutputStream zipOS, MethodParamAnnotations nonnullParams, MethodReturnAnnotations nullableReturns, boolean stripJarSignatures, boolean debug) throws IOException {
        BytecodeAnnotator.debug = debug;
        BytecodeAnnotator.LOG(debug, "DEBUG", "nullableReturns: " + nullableReturns);
        BytecodeAnnotator.LOG(debug, "DEBUG", "nonnullParams: " + nonnullParams);
        Iterator zipIterator = inputZip.stream().iterator();
        while (zipIterator.hasNext()) {
            ZipEntry zipEntry = (ZipEntry)zipIterator.next();
            InputStream is = inputZip.getInputStream(zipEntry);
            zipOS.putNextEntry(new ZipEntry(zipEntry.getName()));
            if (zipEntry.getName().equals("classes.jar")) {
                JarInputStream jarIS = new JarInputStream(is);
                JarEntry inputJarEntry = jarIS.getNextJarEntry();
                ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
                JarOutputStream jarOS = new JarOutputStream(byteArrayOS);
                while (inputJarEntry != null) {
                    BytecodeAnnotator.copyAndAnnotateJarEntry(inputJarEntry, jarIS, jarOS, nonnullParams, nullableReturns, androidNullableDesc, androidNonnullDesc, stripJarSignatures);
                    inputJarEntry = jarIS.getNextJarEntry();
                }
                jarOS.flush();
                jarOS.close();
                zipOS.write(byteArrayOS.toByteArray());
            } else {
                zipOS.write(IOUtils.toByteArray((InputStream)is));
            }
            zipOS.closeEntry();
        }
    }
}

